/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.replication_rs2_bridge.storage;

import com.leclowndu93150.replication_rs2_bridge.block.entity.task.TaskSnapshotNbt;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskSnapshot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class BridgeTaskSnapshotRepository
extends SavedData {
    public static final String NAME = "replication_rs2_bridge_task_snapshots";
    private static final String TAG_BRIDGES = "Bridges";
    private static final String TAG_BRIDGE_ID = "BridgeId";
    private static final String TAG_SNAPSHOTS = "Snapshots";
    private final Map<UUID, List<TaskSnapshot>> bridgeSnapshots = new HashMap<UUID, List<TaskSnapshot>>();

    public BridgeTaskSnapshotRepository() {
    }

    public BridgeTaskSnapshotRepository(CompoundTag tag, HolderLookup.Provider provider) {
        if (tag.contains(TAG_BRIDGES, 9)) {
            ListTag bridgesList = tag.getList(TAG_BRIDGES, 10);
            for (Tag bridgeTag : bridgesList) {
                CompoundTag bridgeCompound = (CompoundTag)bridgeTag;
                UUID bridgeId = bridgeCompound.getUUID(TAG_BRIDGE_ID);
                ArrayList<TaskSnapshot> snapshots = new ArrayList<TaskSnapshot>();
                if (bridgeCompound.contains(TAG_SNAPSHOTS, 9)) {
                    ListTag snapshotsList = bridgeCompound.getList(TAG_SNAPSHOTS, 10);
                    for (Tag snapshotTag : snapshotsList) {
                        try {
                            TaskSnapshot snapshot = TaskSnapshotNbt.decode((CompoundTag)snapshotTag);
                            snapshots.add(snapshot);
                        }
                        catch (Exception exception) {}
                    }
                }
                if (snapshots.isEmpty()) continue;
                this.bridgeSnapshots.put(bridgeId, snapshots);
            }
        }
    }

    public List<TaskSnapshot> getSnapshotsForBridge(UUID bridgeId) {
        return this.bridgeSnapshots.getOrDefault(bridgeId, List.of());
    }

    public void setSnapshotsForBridge(UUID bridgeId, List<TaskSnapshot> snapshots) {
        if (snapshots == null || snapshots.isEmpty()) {
            this.bridgeSnapshots.remove(bridgeId);
        } else {
            this.bridgeSnapshots.put(bridgeId, new ArrayList<TaskSnapshot>(snapshots));
        }
        this.setDirty();
    }

    public void removeBridge(UUID bridgeId) {
        if (this.bridgeSnapshots.remove(bridgeId) != null) {
            this.setDirty();
        }
    }

    @NotNull
    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        ListTag bridgesList = new ListTag();
        for (Map.Entry<UUID, List<TaskSnapshot>> bridgeEntry : this.bridgeSnapshots.entrySet()) {
            if (bridgeEntry.getValue().isEmpty()) continue;
            CompoundTag bridgeCompound = new CompoundTag();
            bridgeCompound.putUUID(TAG_BRIDGE_ID, bridgeEntry.getKey());
            ListTag snapshotsList = new ListTag();
            for (TaskSnapshot snapshot : bridgeEntry.getValue()) {
                try {
                    snapshotsList.add((Object)TaskSnapshotNbt.encode(snapshot));
                }
                catch (Exception exception) {}
            }
            bridgeCompound.put(TAG_SNAPSHOTS, (Tag)snapshotsList);
            bridgesList.add((Object)bridgeCompound);
        }
        tag.put(TAG_BRIDGES, (Tag)bridgesList);
        return tag;
    }
}

