/*
 * Decompiled with CFR 0.152.
 */
package com.respawningstructures.mixin;

import com.respawningstructures.structure.RespawnManager;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.GravityProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={StructureTemplate.class})
public class StructureTemplateProcessRespawnInfoMixin {
    @Inject(method={"processBlockInfos(Lnet/minecraft/world/level/ServerLevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructurePlaceSettings;Ljava/util/List;Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplate;)Ljava/util/List;"}, at={@At(value="HEAD")}, remap=false)
    private static void prepareRespawnHeightData(ServerLevelAccessor p_278297_, BlockPos from, BlockPos to, StructurePlaceSettings structurePlaceSettings, List<StructureTemplate.StructureBlockInfo> structureBlockInfos, StructureTemplate template, CallbackInfoReturnable<List<StructureTemplate.StructureBlockInfo>> cir) {
        if (RespawnManager.respawnInProgress == null) {
            return;
        }
        boolean needsHeightCache = false;
        for (StructureProcessor processor : structurePlaceSettings.getProcessors()) {
            if (!(processor instanceof GravityProcessor)) continue;
            needsHeightCache = true;
            break;
        }
        if (needsHeightCache) {
            Object2IntOpenHashMap heightMap = new Object2IntOpenHashMap();
            for (StructureTemplate.StructureBlockInfo blockInfo : structureBlockInfos) {
                int height;
                if (blockInfo.pos().getY() <= 0 || blockInfo.state().isAir() || (height = heightMap.getInt((Object)new BlockPos(blockInfo.pos().getX(), 0, blockInfo.pos().getZ()))) >= blockInfo.pos().getY()) continue;
                heightMap.put((Object)new BlockPos(blockInfo.pos().getX(), 0, blockInfo.pos().getZ()), blockInfo.pos().getY());
            }
            RespawnManager.heightMap = heightMap;
        }
    }
}

