/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.environmental.modules;

import java.util.ArrayList;
import mcjty.rftoolsutility.modules.environmental.blocks.EnvironmentalControllerTileEntity;
import mcjty.rftoolsutility.modules.environmental.modules.EnvironmentModule;
import mcjty.rftoolsutility.playerprops.BuffProperties;
import mcjty.rftoolsutility.playerprops.PlayerBuff;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public abstract class BuffEModule
implements EnvironmentModule {
    public static final int MAXTICKS = 180;
    private boolean active = false;
    private int ticks = 180;
    private final PlayerBuff buff;

    public BuffEModule(PlayerBuff buff) {
        this.buff = buff;
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public void tick(Level world, BlockPos pos, int radius, int miny, int maxy, EnvironmentalControllerTileEntity controllerTileEntity) {
        if (!this.active) {
            return;
        }
        --this.ticks;
        if (this.ticks > 0) {
            return;
        }
        this.ticks = 180;
        double maxsqdist = radius * radius;
        ArrayList players = new ArrayList(world.players());
        for (Player player : players) {
            double py = player.getY();
            if (!(py >= (double)miny) || !(py <= (double)maxy)) continue;
            double px = player.getX();
            double pz = player.getZ();
            double sqdist = (px - (double)pos.getX()) * (px - (double)pos.getX()) + (pz - (double)pos.getZ()) * (pz - (double)pos.getZ());
            if (!(sqdist < maxsqdist) || !controllerTileEntity.isPlayerAffected(player)) continue;
            BuffProperties.addBuffToPlayer(player, this.buff, 180);
        }
    }

    @Override
    public boolean apply(Level world, BlockPos pos, LivingEntity entity, int duration) {
        return false;
    }

    @Override
    public void activate(boolean a) {
        if (this.active == a) {
            return;
        }
        this.active = a;
        this.ticks = 1;
    }

    public static BuffEModule create(PlayerBuff buff, final double rfPerTick) {
        return new BuffEModule(buff){

            @Override
            public float getRfPerTick() {
                return (float)rfPerTick;
            }
        };
    }
}

