/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class MultilineErrorScreen
extends Screen {
    private static final int MAX_LINE_SIZE = 300;
    private static final int LINE_SPACING = 12;
    private final Runnable closeCallback;
    private final List<FormattedCharSequence> messageLines;
    private final int lineWidth;

    public MultilineErrorScreen(Component title, Component message) {
        this(title, message, null);
    }

    public MultilineErrorScreen(Component title, Component message, Runnable closeCallback) {
        super(title);
        this.closeCallback = closeCallback;
        this.messageLines = Minecraft.getInstance().font.split((FormattedText)message, 300);
        this.lineWidth = Math.max(300, this.messageLines.stream().mapToInt(arg_0 -> ((Font)Minecraft.getInstance().font).width(arg_0)).max().orElse(300));
    }

    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> {
            if (this.closeCallback != null) {
                this.closeCallback.run();
            }
            this.minecraft.setScreen(null);
        }).bounds(this.width / 2 - 100, 120 + this.messageLines.size() * 12, 200, 20).build());
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 90, 0xFFFFFF);
        for (int height = 0; height < this.messageLines.size(); ++height) {
            guiGraphics.drawCenteredString(this.minecraft.font, this.messageLines.get(height), this.width / 2, 110 + height * 12, 0xFFFFFF);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.fillGradient(0, 0, this.width, this.height, -12574688, -11530224);
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }
}

