/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.util;

import java.lang.reflect.Field;
import java.util.Collection;
import net.rocketplatform.game.client.mod.util.CatalogedBy;

public class CatalogType<T> {
    private final String type;
    private final Class<T> classType;

    public CatalogType(String type, Class<T> classType) {
        this.type = type;
        this.classType = classType;
    }

    public String getType() {
        return this.type;
    }

    public Class<T> getClassType() {
        return this.classType;
    }

    public static <T> Collection<CatalogType<T>> getValues(Class<?> catalogType) {
        CatalogedBy catalogedBy = catalogType.getAnnotation(CatalogedBy.class);
        if (catalogedBy == null) {
            throw new IllegalArgumentException("Root type must be annotated with @CatalogedBy");
        }
        try {
            Field valuesField = catalogedBy.value().getDeclaredField("VALUES");
            valuesField.setAccessible(true);
            return (Collection)valuesField.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Failed to get values from catalog type", e);
        }
    }
}

