/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.block.tile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.tarantel.chickenroost.block.blocks.ModBlocks;
import net.tarantel.chickenroost.block.blocks.RoostBlock;
import net.tarantel.chickenroost.block.tile.ModBlockEntities;
import net.tarantel.chickenroost.block.tile.RoostTile;
import net.tarantel.chickenroost.handler.FeederHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FeederTile
extends BlockEntity
implements MenuProvider {
    public final ItemStackHandler itemHandler = new ItemStackHandler(54){

        protected void onContentsChanged(int slot) {
            FeederTile.this.setChanged();
            if (FeederTile.this.level != null && !((FeederTile)FeederTile.this).level.isClientSide) {
                FeederTile.this.level.sendBlockUpdated(FeederTile.this.getBlockPos(), FeederTile.this.getBlockState(), FeederTile.this.getBlockState(), 3);
            }
        }
    };
    private final Set<BlockPos> activeRoosts = new HashSet<BlockPos>();
    private int feedRange = 10;
    private final Map<BlockPos, Item> preferredSeeds = new HashMap<BlockPos, Item>();
    private boolean roundRobinEnabled = false;
    private int roundRobinIndex = 0;
    private StackSendMode stackSendMode = StackSendMode.SINGLE;
    private int _roostValidationTicker = 0;

    public FeederTile(BlockPos pos, BlockState state) {
        super(ModBlockEntities.FEEDER.get(), pos, state);
    }

    public int getFeedRange() {
        return this.feedRange;
    }

    public void setFeedRange(int r) {
        if (this.feedRange != (r = Math.max(5, Math.min(30, r)))) {
            this.feedRange = r;
            this.setChanged();
            if (this.level != null && !this.level.isClientSide) {
                this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            }
        }
    }

    public void addActiveRoost(BlockPos roost) {
        if (this.activeRoosts.add(roost.immutable())) {
            this.setChanged();
            if (this.level != null && !this.level.isClientSide) {
                this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            }
        }
    }

    public void removeActiveRoost(BlockPos roost) {
        if (this.activeRoosts.remove(roost)) {
            this.setChanged();
            if (this.level != null && !this.level.isClientSide) {
                this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            }
        }
    }

    public Set<BlockPos> getActiveRoosts() {
        return Collections.unmodifiableSet(this.activeRoosts);
    }

    public void setPreferredSeed(BlockPos roostPos, @Nullable Item item) {
        if (item == null) {
            this.preferredSeeds.remove(roostPos);
        } else {
            this.preferredSeeds.put(roostPos.immutable(), item);
        }
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    @Nullable
    public Item getPreferredSeed(BlockPos roostPos) {
        return this.preferredSeeds.get(roostPos);
    }

    public boolean isRoundRobinEnabled() {
        return this.roundRobinEnabled;
    }

    public void setRoundRobinEnabled(boolean enabled) {
        if (this.roundRobinEnabled == enabled) {
            return;
        }
        this.roundRobinEnabled = enabled;
        this.roundRobinIndex = 0;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public StackSendMode getStackSendMode() {
        return this.stackSendMode;
    }

    public int getStackSendModeId() {
        return this.stackSendMode.id();
    }

    public void setStackSendMode(StackSendMode mode) {
        if (mode == null) {
            mode = StackSendMode.SINGLE;
        }
        if (this.stackSendMode == mode) {
            return;
        }
        this.stackSendMode = mode;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void setStackSendModeById(int id) {
        this.setStackSendMode(StackSendMode.byId(id));
    }

    public void saveAdditional(CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookup) {
        nbt.put("inventory", (Tag)this.itemHandler.serializeNBT(lookup));
        long[] arr = this.activeRoosts.stream().mapToLong(BlockPos::asLong).toArray();
        nbt.putLongArray("feeder.roosts", arr);
        nbt.putInt("feeder.range", this.feedRange);
        nbt.putBoolean("feeder.round_robin", this.roundRobinEnabled);
        nbt.putInt("feeder.round_robin_index", this.roundRobinIndex);
        nbt.putInt("feeder.stack_send_mode", this.stackSendMode.id());
        ListTag list = new ListTag();
        for (Map.Entry<BlockPos, Item> e : this.preferredSeeds.entrySet()) {
            CompoundTag t = new CompoundTag();
            t.putLong("pos", e.getKey().asLong());
            ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)e.getValue());
            t.putString("item", key.toString());
            list.add((Object)t);
        }
        nbt.put("feeder.preferredSeeds", (Tag)list);
        super.saveAdditional(nbt, lookup);
    }

    public void loadAdditional(@NotNull CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookup) {
        long[] arr;
        super.loadAdditional(nbt, lookup);
        this.itemHandler.deserializeNBT(lookup, nbt.getCompound("inventory"));
        this.preferredSeeds.clear();
        if (nbt.contains("feeder.preferredSeeds")) {
            ListTag list = nbt.getList("feeder.preferredSeeds", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag t = list.getCompound(i);
                BlockPos p = BlockPos.of((long)t.getLong("pos"));
                if (!t.contains("item")) continue;
                Item it = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)t.getString("item")));
                this.preferredSeeds.put(p, it);
            }
        }
        this.activeRoosts.clear();
        for (long l : arr = nbt.getLongArray("feeder.roosts")) {
            this.activeRoosts.add(BlockPos.of((long)l));
        }
        this.feedRange = Math.max(5, Math.min(30, nbt.getInt("feeder.range")));
        this.roundRobinEnabled = nbt.getBoolean("feeder.round_robin");
        this.roundRobinIndex = nbt.getInt("feeder.round_robin_index");
        this.stackSendMode = StackSendMode.byId(nbt.getInt("feeder.stack_send_mode"));
        this.pruneMissingRoosts();
    }

    private static void feedFromActiveRoosts(Level level, FeederTile self) {
        if (self.activeRoosts.isEmpty()) {
            return;
        }
        int r = self.getFeedRange();
        int maxDist2 = r * r;
        ArrayList<BlockPos> candidates = new ArrayList<BlockPos>();
        for (BlockPos rpos : self.activeRoosts) {
            BlockEntity be;
            if (rpos.distSqr((Vec3i)self.getBlockPos()) > (double)(maxDist2 * 3) || !((be = level.getBlockEntity(rpos)) instanceof RoostTile)) continue;
            candidates.add(rpos);
        }
        if (candidates.isEmpty()) {
            return;
        }
        candidates.sort(Comparator.comparingLong(BlockPos::asLong));
        if (!self.roundRobinEnabled) {
            for (BlockPos rpos : candidates) {
                FeederTile.feedSingleRoost(level, self, rpos);
            }
        } else {
            int idx = Math.floorMod(self.roundRobinIndex, candidates.size());
            BlockPos chosen = (BlockPos)candidates.get(idx);
            FeederTile.feedSingleRoost(level, self, chosen);
            self.roundRobinIndex = (idx + 1) % candidates.size();
            self.setChanged();
        }
    }

    private static void feedSingleRoost(Level level, FeederTile self, BlockPos rpos) {
        Item desired;
        IItemHandler roostInv = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, rpos, null);
        if (roostInv == null) {
            return;
        }
        ItemStack target = roostInv.getStackInSlot(0);
        Item item = desired = !target.isEmpty() ? target.getItem() : self.preferredSeeds.get(rpos);
        if (desired == null) {
            return;
        }
        ItemStack probe = new ItemStack((ItemLike)desired, desired.getDefaultMaxStackSize());
        ItemStack remainder = roostInv.insertItem(0, probe.copy(), true);
        int canAccept = probe.getCount() - (remainder.isEmpty() ? 0 : remainder.getCount());
        if (canAccept <= 0) {
            return;
        }
        int modeLimit = self.stackSendMode.limitFor(probe);
        int toMove = Math.min(canAccept, modeLimit);
        for (int i = 0; i < self.itemHandler.getSlots() && toMove > 0; ++i) {
            int moveCount;
            ItemStack extractedSim;
            ItemStack src = self.itemHandler.getStackInSlot(i);
            if (src.isEmpty() || src.getItem() != desired || (extractedSim = self.itemHandler.extractItem(i, moveCount = Math.min(toMove, src.getCount()), true)).isEmpty()) continue;
            ItemStack leftover = roostInv.insertItem(0, extractedSim, false);
            int moved = extractedSim.getCount() - (leftover.isEmpty() ? 0 : leftover.getCount());
            if (moved <= 0) continue;
            self.itemHandler.extractItem(i, moved, false);
            toMove -= moved;
        }
    }

    public void drops() {
        SimpleContainer block = new SimpleContainer(1);
        ItemStack itemStack = new ItemStack((ItemLike)ModBlocks.FEEDER.get());
        NonNullList items = NonNullList.withSize((int)this.itemHandler.getSlots(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            items.set(i, (Object)this.itemHandler.getStackInSlot(i));
        }
        itemStack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)items));
        block.setItem(0, itemStack.copy());
        Containers.dropContents((Level)Objects.requireNonNull(this.level), (BlockPos)this.worldPosition, (Container)block);
    }

    private boolean isValidRoost(BlockPos pos) {
        if (this.level == null || pos == null) {
            return false;
        }
        BlockEntity be = this.level.getBlockEntity(pos);
        if (!(be instanceof RoostTile)) {
            return false;
        }
        BlockState state = this.level.getBlockState(pos);
        return state.getBlock() instanceof RoostBlock;
    }

    private void pruneMissingRoosts() {
        if (this.level == null || this.activeRoosts.isEmpty()) {
            return;
        }
        this.activeRoosts.removeIf(pos -> !this.isValidRoost((BlockPos)pos));
    }

    private void maybePruneRoostsPeriodic() {
        if (++this._roostValidationTicker % 20 == 0) {
            this.pruneMissingRoosts();
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, FeederTile tile) {
        if (level.isClientSide()) {
            return;
        }
        tile.maybePruneRoostsPeriodic();
        FeederTile.feedFromActiveRoosts(level, tile);
        FeederTile.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider prov) {
        return this.saveWithFullMetadata(prov);
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        return this.itemHandler;
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"block.chicken_roost.feeder");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, @NotNull Inventory inv, @NotNull Player player) {
        return new FeederHandler(id, inv, this);
    }

    public static enum StackSendMode {
        SINGLE,
        HALF,
        FULL;


        public StackSendMode next() {
            return StackSendMode.values()[(this.ordinal() + 1) % StackSendMode.values().length];
        }

        public int limitFor(ItemStack stack) {
            int max = Math.max(1, stack.getMaxStackSize());
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> 1;
                case 1 -> Math.max(1, max / 2);
                case 2 -> max;
            };
        }

        public int id() {
            return this.ordinal();
        }

        public static StackSendMode byId(int id) {
            if (id < 0 || id >= StackSendMode.values().length) {
                return SINGLE;
            }
            return StackSendMode.values()[id];
        }
    }
}

