/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.item.base;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.tarantel.chickenroost.item.base.ChickenItemBase;
import net.tarantel.chickenroost.item.renderer.AnimatedChickenRenderer;
import net.tarantel.chickenroost.util.ClientBiomeCache;
import net.tarantel.chickenroost.util.Config;
import net.tarantel.chickenroost.util.ModDataComponents;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;
import software.bernie.geckolib.util.RenderUtil;

public class AnimatedChicken
extends ChickenItemBase
implements GeoItem {
    private static final String NBT_LEVEL_KEY = "chickenlevel";
    private static final String NBT_XP_KEY = "chickenxp";
    private static final String NBT_AGE_KEY = "age";
    private static final ResourceLocation C_VANILLA_ID = ResourceLocation.fromNamespaceAndPath((String)"chicken_roost", (String)"c_vanilla");
    private final String localpath;
    private final int currentchickena;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public AnimatedChicken(Item.Properties properties, String path, int currentchicken) {
        super(properties, currentchicken);
        this.localpath = path;
        this.currentchickena = currentchicken;
    }

    public String getLocalpath() {
        return this.localpath;
    }

    public static BlockPos rightposi(BlockPos blockPos, Direction direction) {
        int[] xside = new int[]{0, 0, 0, 0, -1, 1};
        int[] yside = new int[]{-1, 1, 0, 0, 0, 0};
        int[] zside = new int[]{0, 0, -1, 1, 0, 0};
        int x = blockPos.getX() + xside[direction.ordinal()];
        int y = blockPos.getY() + yside[direction.ordinal()];
        int z = blockPos.getZ() + zside[direction.ordinal()];
        return new BlockPos(x, y, z);
    }

    @Nullable
    private static ServerLevel asServer(Level level) {
        ServerLevel s;
        return level instanceof ServerLevel ? (s = (ServerLevel)level) : null;
    }

    private static boolean isVanillaChickenItem(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item).equals((Object)C_VANILLA_ID);
    }

    private static EntityType<?> resolveEntityType(Item item) {
        if (item instanceof ChickenItemBase && !AnimatedChicken.isVanillaChickenItem(item)) {
            ResourceLocation id = ResourceLocation.parse((String)item.getDefaultInstance().getItemHolder().getRegisteredName());
            return (EntityType)BuiltInRegistries.ENTITY_TYPE.get(id);
        }
        return (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)"minecraft:chicken"));
    }

    private static void applyChickenData(Entity entity, ItemStack stack) {
        if (stack.has(ModDataComponents.CHICKENLEVEL)) {
            entity.getPersistentData().putInt(NBT_LEVEL_KEY, ((Integer)stack.get((DataComponentType)ModDataComponents.CHICKENLEVEL.value())).intValue());
        }
        if (stack.has(ModDataComponents.CHICKENXP)) {
            entity.getPersistentData().putInt(NBT_XP_KEY, ((Integer)stack.get((DataComponentType)ModDataComponents.CHICKENXP.value())).intValue());
        }
        if (stack.has(ModDataComponents.AGE)) {
            entity.getPersistentData().putInt(NBT_AGE_KEY, ((Integer)stack.get((DataComponentType)ModDataComponents.AGE.value())).intValue());
        }
    }

    private void postSpawnSideEffects(ServerLevel level, @Nullable Player player, ItemStack stack, BlockPos posOrEntityPos) {
        stack.consume(1, (LivingEntity)player);
        if (player != null) {
            player.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, posOrEntityPos);
    }

    private boolean spawn(ServerLevel level, @Nullable Player player, ItemStack stack, BlockPos pos) {
        EntityType<?> type = AnimatedChicken.resolveEntityType(stack.getItem());
        Entity e = type.spawn(level, stack, player, pos, MobSpawnType.SPAWN_EGG, false, false);
        if (e == null) {
            return false;
        }
        AnimatedChicken.applyChickenData(e, stack);
        this.postSpawnSideEffects(level, player, stack, pos);
        return true;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        ServerLevel server = AnimatedChicken.asServer(ctx.getLevel());
        if (server == null) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = ctx.getItemInHand();
        BlockPos pos = AnimatedChicken.rightposi(ctx.getClickedPos(), ctx.getClickedFace());
        boolean ok = this.spawn(server, ctx.getPlayer(), stack, pos);
        return ok ? InteractionResult.CONSUME : InteractionResult.PASS;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        BlockHitResult hit = AnimatedChicken.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (hit.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (!(level.getBlockState(hit.getBlockPos()).getBlock() instanceof LiquidBlock)) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (!(level instanceof ServerLevel)) {
            return InteractionResultHolder.success((Object)stack);
        }
        ServerLevel server = (ServerLevel)level;
        BlockPos pos = hit.getBlockPos();
        if (!level.mayInteract(player, pos) || !player.mayUseItemAt(pos, hit.getDirection(), stack)) {
            return InteractionResultHolder.fail((Object)stack);
        }
        boolean ok = this.spawn(server, player, stack, pos);
        return ok ? InteractionResultHolder.consume((Object)stack) : InteractionResultHolder.pass((Object)stack);
    }

    public void appendHoverText(@NotNull ItemStack itemstack, @NotNull Item.TooltipContext context, @NotNull List<Component> list, @NotNull TooltipFlag flag) {
        try {
            super.appendHoverText(itemstack, context, list, flag);
            int maxLevel = switch (this.currentchickena) {
                case 1 -> (Integer)Config.maxlevel_tier_2.get();
                case 2 -> (Integer)Config.maxlevel_tier_3.get();
                case 3 -> (Integer)Config.maxlevel_tier_4.get();
                case 4 -> (Integer)Config.maxlevel_tier_5.get();
                case 5 -> (Integer)Config.maxlevel_tier_6.get();
                case 6 -> (Integer)Config.maxlevel_tier_7.get();
                case 7 -> (Integer)Config.maxlevel_tier_8.get();
                case 8 -> (Integer)Config.maxlevel_tier_9.get();
                default -> (Integer)Config.maxlevel_tier_1.get();
            };
            int maxXP = switch (this.currentchickena) {
                case 1 -> (Integer)Config.xp_tier_2.get();
                case 2 -> (Integer)Config.xp_tier_3.get();
                case 3 -> (Integer)Config.xp_tier_4.get();
                case 4 -> (Integer)Config.xp_tier_5.get();
                case 5 -> (Integer)Config.xp_tier_6.get();
                case 6 -> (Integer)Config.xp_tier_7.get();
                case 7 -> (Integer)Config.xp_tier_8.get();
                case 8 -> (Integer)Config.xp_tier_9.get();
                default -> (Integer)Config.xp_tier_1.get();
            };
            int level = 0;
            int xp = 0;
            if (itemstack.has(ModDataComponents.CHICKENLEVEL)) {
                level = (Integer)itemstack.get((DataComponentType)ModDataComponents.CHICKENLEVEL.value());
            }
            if (itemstack.has(ModDataComponents.CHICKENXP)) {
                xp = (Integer)itemstack.get((DataComponentType)ModDataComponents.CHICKENXP.value());
            }
            list.add((Component)Component.translatable((String)"roost_chicken.chickeninfo.tier", (Object[])new Object[]{this.currentchickena + 1}));
            list.add((Component)Component.translatable((String)"roost_chicken.chickeninfo.level", (Object[])new Object[]{level, maxLevel}));
            list.add((Component)Component.translatable((String)"roost_chicken.chickeninfo.xp", (Object[])new Object[]{xp, maxXP}));
            String itemId = BuiltInRegistries.ITEM.getKey((Object)itemstack.getItem()).toString();
            List<String> biomes = ClientBiomeCache.getBiomes(itemId);
            if (!biomes.isEmpty()) {
                list.add((Component)Component.translatable((String)"roost_chicken.biomeinfo.spawn"));
                for (String biome : biomes) {
                    try {
                        list.add((Component)Component.translatable((String)" - %s", (Object[])new Object[]{Component.translatable((String)("biome." + biome.replace(":", ".")))}));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                list.add((Component)Component.translatable((String)"roost_chicken.biomeinfo.nospawn"));
            }
            list.add(Component.nullToEmpty((String)"\u00a71 Roost Ultimate"));
        }
        catch (Exception e) {
            System.out.println("Error in Tooltip:");
            e.printStackTrace();
        }
    }

    private PlayState predicate(AnimationState animationState) {
        animationState.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object itemStack) {
        return RenderUtil.getCurrentTick();
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(this){
            private AnimatedChickenRenderer renderer;

            @NotNull
            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new AnimatedChickenRenderer();
                }
                return this.renderer;
            }
        });
    }

    public float getDestroySpeed(@NotNull ItemStack par1ItemStack, @NotNull BlockState par2Block) {
        return 0.0f;
    }
}

