/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.tarantel.chickenroost.ChickenRoostMod;
import net.tarantel.chickenroost.recipes.CodecFix;
import org.jetbrains.annotations.NotNull;

public record TrainerRecipe(ItemStack output, Ingredient ingredient0) implements Recipe<RecipeInput>
{
    @NotNull
    public ItemStack assemble(@NotNull RecipeInput container, @NotNull HolderLookup.Provider registries) {
        return this.output;
    }

    public ResourceLocation getId() {
        return ChickenRoostMod.ownresource("trainer_output");
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.output.copy();
    }

    public ItemStack getResultEmi() {
        return this.output.copy();
    }

    public boolean matches(@NotNull RecipeInput pContainer, Level pLevel) {
        if (pLevel.isClientSide()) {
            return false;
        }
        return this.ingredient0.test(pContainer.getItem(0));
    }

    public boolean isSpecial() {
        return true;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList ingredients = NonNullList.createWithCapacity((int)1);
        ingredients.addFirst((Object)this.ingredient0);
        return ingredients;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public String getGroup() {
        return "trainer_output";
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public static final class Serializer
    implements RecipeSerializer<TrainerRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = ChickenRoostMod.ownresource("trainer_output");
        private final MapCodec<TrainerRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CodecFix.ITEM_STACK_CODEC.fieldOf("output").forGetter(recipe -> recipe.output.copy()), (App)Ingredient.CODEC_NONEMPTY.fieldOf("chicken").forGetter(recipe -> recipe.ingredient0)).apply((Applicative)instance, TrainerRecipe::new));
        private final StreamCodec<RegistryFriendlyByteBuf, TrainerRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        private Serializer() {
        }

        @NotNull
        public MapCodec<TrainerRecipe> codec() {
            return this.CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, TrainerRecipe> streamCodec() {
            return this.STREAM_CODEC;
        }

        private static TrainerRecipe read(RegistryFriendlyByteBuf buffer) {
            Ingredient input0 = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            ItemStack output = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
            return new TrainerRecipe(output, input0);
        }

        private static void write(RegistryFriendlyByteBuf buffer, TrainerRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient0);
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
        }
    }

    public static final class Type
    implements RecipeType<TrainerRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "trainer_output";

        private Type() {
        }
    }
}

