/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.PacketDistributor;
import net.tarantel.chickenroost.ChickenRoostMod;
import net.tarantel.chickenroost.handler.RoostHandler;
import net.tarantel.chickenroost.networking.SetRoostAutoOutputPayload;
import net.tarantel.chickenroost.networking.SetRoostNamePayload;
import net.tarantel.chickenroost.util.Config;
import org.jetbrains.annotations.NotNull;

public class RoostScreen
extends AbstractContainerScreen<RoostHandler> {
    private boolean colorblindMode = (Boolean)Config.roost_cb.get();
    private EditBox nameField;
    private String enteredName = "ROOST";
    private Button nameButton;
    private static final ResourceLocation GUI = ChickenRoostMod.ownresource("textures/screens/roostgui.png");
    private static final ResourceLocation ARROW = ChickenRoostMod.ownresource("textures/screens/newarrow.png");
    private static final ResourceLocation ARROW_VANILLA = ChickenRoostMod.ownresource("textures/screens/arrow.png");
    private static final ResourceLocation GUI_VANILLA = ChickenRoostMod.ownresource("textures/screens/roost_vanilla.png");
    private static final ResourceLocation ARROWBACK_VANILLA = ChickenRoostMod.ownresource("textures/screens/arrowback.png");
    private Button output;

    public RoostScreen(RoostHandler menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    protected void init() {
        super.init();
        int x = this.leftPos;
        int y = this.topPos - 17;
        this.output = Button.builder((Component)this.makeOutputText(), button -> {
            boolean newValue = !((RoostHandler)this.menu).blockEntity.isAutoOutputEnabled();
            ((RoostHandler)this.menu).blockEntity.setAutoOutputEnabled(newValue);
            button.setMessage(this.makeOutputText());
            PacketDistributor.sendToServer((CustomPacketPayload)new SetRoostAutoOutputPayload(((RoostHandler)this.menu).blockEntity.getBlockPos(), newValue), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }).pos(this.leftPos + 13, this.topPos - 17).size(70, 13).build();
        this.addRenderableWidget((GuiEventListener)this.output);
        this.output.setTooltip(Tooltip.create((Component)Component.translatable((String)"roost_chicken.interface.output.info")));
        Button b = Button.builder((Component)Component.literal((String)"V"), button -> {
            if (this.colorblindMode) {
                Config.roost_cb.set((Object)false);
                Config.roost_cb.save();
            } else {
                Config.roost_cb.set((Object)true);
                Config.roost_cb.save();
            }
        }).pos(this.leftPos, this.topPos - 17).size(13, 13).build();
        b.setTooltip(Tooltip.create((Component)Component.translatable((String)"roost_chicken.interface.uiswitch.info")));
        this.addRenderableWidget((GuiEventListener)b);
        int nameBtnX = this.leftPos + 20 + 2 + 61;
        int nameBtnY = this.topPos - 17;
        this.nameButton = Button.builder((Component)Component.translatable((String)"roost_chicken.interface.name"), btn -> {
            int fieldX = nameBtnX + 40 + 2;
            int fieldY = this.topPos - 21;
            if (this.nameField == null) {
                this.nameField = new EditBox(this.font, fieldX, fieldY, 60, 20, (Component)Component.translatable((String)"roost_chicken.interface.name").withColor(0xFFFFFF));
                this.nameField.setMaxLength(32);
                String currentname = ((RoostHandler)this.menu).blockEntity.getCustomName();
                this.nameField.setValue(currentname);
                this.nameField.setFocused(true);
                this.addRenderableWidget((GuiEventListener)this.nameField);
            } else {
                this.nameField.setFocused(true);
            }
        }).pos(nameBtnX, nameBtnY).size(40, 13).build();
        this.nameButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"roost_chicken.interface.setname")));
        this.addRenderableWidget((GuiEventListener)this.nameButton);
    }

    private Component makeOutputText() {
        boolean enabled = ((RoostHandler)this.menu).blockEntity.isAutoOutputEnabled();
        MutableComponent state = Component.translatable((String)(enabled ? "roost_chicken.interface.output.on" : "roost_chicken.interface.output.off")).withStyle(enabled ? ChatFormatting.GREEN : ChatFormatting.RED);
        return Component.translatable((String)"roost_chicken.interface.output.name", (Object[])new Object[]{state});
    }

    private int getScaledProgress() {
        boolean colorblindMode = (Boolean)Config.roost_cb.get();
        int arrowWidth = 54;
        return ((RoostHandler)this.menu).getScaledProgress(arrowWidth);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.nameField != null && this.nameField.isFocused()) {
            if (keyCode == 256) {
                return super.keyPressed(keyCode, scanCode, modifiers);
            }
            if (keyCode == 257 || keyCode == 257 || keyCode == 335) {
                this.enteredName = this.nameField.getValue().trim();
                if (!this.enteredName.isEmpty()) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new SetRoostNamePayload(((RoostHandler)this.menu).getBlockEntity().getBlockPos(), this.enteredName), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                this.nameField.setFocused(false);
                return true;
            }
            if (this.nameField.keyPressed(keyCode, scanCode, modifiers)) {
                return true;
            }
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (this.nameField != null && this.nameField.isFocused()) {
            if (this.nameField.charTyped(codePoint, modifiers)) {
                return true;
            }
            return true;
        }
        return super.charTyped(codePoint, modifiers);
    }

    protected void renderBg(@NotNull GuiGraphics ms, float partialTicks, int gx, int gy) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        if (this.colorblindMode) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_VANILLA);
            ms.blit(GUI_VANILLA, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
            ms.blit(ARROW, this.leftPos + 63, this.topPos + 11, 0.0f, 0.0f, this.getScaledProgress(), 33, 54, 33);
        } else {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI);
            ms.blit(GUI, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
            ms.blit(ARROW, this.leftPos + 63, this.topPos + 11, 0.0f, 0.0f, this.getScaledProgress(), 33, 54, 33);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        this.colorblindMode = (Boolean)Config.roost_cb.get();
    }

    public void render(@NotNull GuiGraphics ms, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(ms, mouseX, mouseY, partialTicks);
        super.render(ms, mouseX, mouseY, partialTicks);
        this.renderTooltip(ms, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }
}

