/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.util;

import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@Mod(value="chicken_roost", dist={Dist.CLIENT})
public class ClientBiomeCache {
    private static final Map<String, List<String>> ENTITY_TO_BIOMES = new HashMap<String, List<String>>();
    public static boolean initialized = false;
    private static final Path CACHE_FILE = Minecraft.getInstance().gameDirectory.toPath().resolve("chicken_biomes.json");

    /*
     * Loose catch block
     */
    public static void initialize(Level level) {
        block8: {
            if (initialized || level == null) {
                return;
            }
            initialized = true;
            ENTITY_TO_BIOMES.clear();
            RegistryAccess registryAccess = level.registryAccess();
            Registry biomeModifierRegistry = registryAccess.registryOrThrow(NeoForgeRegistries.Keys.BIOME_MODIFIERS);
            Registry biomeRegistry = registryAccess.registryOrThrow(Registries.BIOME);
            for (Map.Entry entry : biomeModifierRegistry.entrySet()) {
                BiomeModifier modifier = (BiomeModifier)entry.getValue();
                if (!(modifier instanceof BiomeModifiers.AddSpawnsBiomeModifier)) continue;
                Object object = (BiomeModifiers.AddSpawnsBiomeModifier)modifier;
                Object object2 = object.biomes();
                HolderSet biomes = object2;
                Object spawners = object2 = object.spawners();
                object = spawners.iterator();
                while (object.hasNext()) {
                    MobSpawnSettings.SpawnerData spawner = (MobSpawnSettings.SpawnerData)object.next();
                    ResourceLocation entityId = BuiltInRegistries.ENTITY_TYPE.getKey((Object)spawner.type);
                    List biomeList = ENTITY_TO_BIOMES.computeIfAbsent(entityId.toString(), k -> new ArrayList());
                    if (biomes instanceof HolderSet.Named) {
                        HolderSet.Named named = (HolderSet.Named)biomes;
                        TagKey tag = named.key();
                        biomeRegistry.getTag(tag).ifPresent(tagged -> {
                            for (Holder holder : tagged) {
                                ResourceLocation loc = biomeRegistry.getKey((Object)((Biome)holder.value()));
                                if (loc == null || biomeList.contains(loc.toString())) continue;
                                biomeList.add(loc.toString());
                            }
                        });
                        continue;
                    }
                    if (!(biomes instanceof HolderSet.Direct)) continue;
                    HolderSet.Direct direct = (HolderSet.Direct)biomes;
                    for (Holder holder : direct) {
                        ResourceLocation loc = biomeRegistry.getKey((Object)((Biome)holder.value()));
                        if (loc == null || biomeList.contains(loc.toString())) continue;
                        biomeList.add(loc.toString());
                    }
                }
            }
            break block8;
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
        ClientBiomeCache.saveToJson();
    }

    public static void saveToJson() {
        try (BufferedWriter writer = Files.newBufferedWriter(CACHE_FILE, new OpenOption[0]);){
            new GsonBuilder().setPrettyPrinting().create().toJson(ENTITY_TO_BIOMES, (Appendable)writer);
            System.out.println("[GlobalBiomeCache] Cache gespeichert: " + String.valueOf(CACHE_FILE));
        }
        catch (Exception e) {
            System.err.println("[GlobalBiomeCache] Fehler beim Speichern!");
            e.printStackTrace();
        }
    }

    public static List<String> getBiomes(String entityId) {
        return ENTITY_TO_BIOMES.getOrDefault(entityId, List.of());
    }
}

