/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.routers.block.entity;

import com.benbenlaw.routers.block.ImporterBlock;
import com.benbenlaw.routers.block.entity.MekanismCompat;
import com.benbenlaw.routers.block.entity.RoutersBlockEntities;
import com.benbenlaw.routers.integration.RoutersCapabilities;
import com.benbenlaw.routers.screen.ImporterMenu;
import com.benbenlaw.routers.screen.util.FluidContainerHelper;
import com.buuz135.industrialforegoingsouls.block.tile.NetworkBlockEntity;
import com.buuz135.industrialforegoingsouls.block_network.SoulNetwork;
import com.buuz135.industrialforegoingsouls.capabilities.ISoulHandler;
import com.buuz135.industrialforegoingsouls.capabilities.SoulCapabilities;
import com.hollingsworth.arsnouveau.api.source.ISourceCap;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImporterBlockEntity
extends BlockEntity
implements MenuProvider {
    private BlockPos extractorPos;
    private IItemHandler itemHandler;
    private IFluidHandler fluidHandler;
    private IEnergyStorage energyStorage;
    private IChemicalHandler chemicalHandler;
    private ISourceCap sourceStorage;
    private ISoulHandler soulHandler;
    private SoulNetwork soulNetwork;
    private IAirHandlerMachine pressureHandler;
    private IHeatExchangerLogic heatHandlerPC;
    public final ContainerData data;
    private String dimension = "";
    private final NonNullList<ItemStack> filters = NonNullList.withSize((int)18, (Object)ItemStack.EMPTY);
    private final NonNullList<FluidStack> fluidFilters = NonNullList.withSize((int)18, (Object)FluidStack.EMPTY);
    private final NonNullList<?> chemicalFilters = ModList.get().isLoaded("mekanism") ? MekanismCompat.createChemicalFilters() : NonNullList.withSize((int)18, (Object)ItemStack.EMPTY);

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"block.routers.importer_block");
    }

    public AbstractContainerMenu createMenu(int container, @NotNull Inventory inventory, @NotNull Player player) {
        return new ImporterMenu(container, inventory, this.getBlockPos(), this.data);
    }

    public ImporterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RoutersBlockEntities.IMPORTER_BLOCK_ENTITY.get(), pos, state);
        this.data = new ContainerData(this){
            private final int[] values = new int[2];

            public int get(int index) {
                return this.values[index];
            }

            public void set(int index, int value) {
                this.values[index] = value;
            }

            public int getCount() {
                return this.values.length;
            }
        };
    }

    public String getDimension() {
        return this.dimension;
    }

    public String setDimension(String dimension) {
        this.dimension = dimension;
        return this.dimension;
    }

    public NonNullList<ItemStack> getFilters() {
        return this.filters;
    }

    public NonNullList<FluidStack> getFluidFilters() {
        return this.fluidFilters;
    }

    public NonNullList<?> getChemicalFilters() {
        return this.chemicalFilters;
    }

    public void tick() {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        Direction facing = (Direction)this.getBlockState().getValue((Property)ImporterBlock.FACING);
        BlockPos targetPos = this.worldPosition.relative(facing);
        assert (this.level != null);
        BlockEntity targetBlockEntity = this.level.getBlockEntity(targetPos);
        Direction inputDirection = facing.getOpposite();
        if (this.level.getGameTime() % 20L != 0L) {
            return;
        }
        if (this.dimension == null || this.dimension.isEmpty()) {
            this.dimension = this.level.dimension().location().toString();
            this.setChanged();
        }
        if (targetBlockEntity != null) {
            ISourceCap sourceHandler;
            IChemicalHandler chemicalHandler;
            IEnergyStorage energyStorage;
            IFluidHandler fluidHandler;
            IItemHandler itemHandler = (IItemHandler)Capabilities.ItemHandler.BLOCK.getCapability(this.level, targetPos, this.level.getBlockState(targetPos), targetBlockEntity, (Object)inputDirection);
            if (itemHandler != null) {
                this.setItemHandler(itemHandler);
            }
            if ((fluidHandler = (IFluidHandler)Capabilities.FluidHandler.BLOCK.getCapability(this.level, targetPos, this.level.getBlockState(targetPos), targetBlockEntity, (Object)inputDirection)) != null) {
                this.setFluidHandler(fluidHandler);
            }
            if ((energyStorage = (IEnergyStorage)Capabilities.EnergyStorage.BLOCK.getCapability(this.level, targetPos, this.level.getBlockState(targetPos), targetBlockEntity, (Object)inputDirection)) != null) {
                this.setEnergyStorage(energyStorage);
            }
            if (ModList.get().isLoaded("mekanism") && (chemicalHandler = (IChemicalHandler)RoutersCapabilities.CHEMICAL_HANDLER.getCapability(this.level, targetPos, this.level.getBlockState(targetPos), targetBlockEntity, (Object)inputDirection)) != null) {
                this.setChemicalHandler(chemicalHandler);
            }
            if (ModList.get().isLoaded("ars_nouveau") && (sourceHandler = (ISourceCap)CapabilityRegistry.SOURCE_CAPABILITY.getCapability(this.level, targetPos, this.level.getBlockState(targetPos), targetBlockEntity, (Object)inputDirection)) != null) {
                this.setSourceHandler(sourceHandler);
            }
            if (ModList.get().isLoaded("industrialforegoingsouls")) {
                NetworkBlockEntity networkBlockEntity;
                SoulNetwork soulNetwork;
                ISoulHandler soulHandler = (ISoulHandler)SoulCapabilities.BLOCK.getCapability(this.level, targetPos, this.level.getBlockState(targetPos), targetBlockEntity, (Object)inputDirection);
                if (soulHandler != null) {
                    this.setSoulHandler(soulHandler);
                }
                if (targetBlockEntity instanceof NetworkBlockEntity && (soulNetwork = (networkBlockEntity = (NetworkBlockEntity)targetBlockEntity).getNetwork()) instanceof SoulNetwork) {
                    SoulNetwork soulNetwork2 = soulNetwork;
                    this.setSoulNetwork(soulNetwork2);
                }
            }
            if (ModList.get().isLoaded("pneumaticcraft")) {
                IHeatExchangerLogic heatHandler;
                IAirHandlerMachine pressureHandler = (IAirHandlerMachine)this.level.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE, targetBlockEntity.getBlockPos(), (Object)inputDirection);
                if (pressureHandler != null) {
                    this.setPressureHandler(pressureHandler);
                }
                if ((heatHandler = (IHeatExchangerLogic)this.level.getCapability(PNCCapabilities.HEAT_EXCHANGER_BLOCK, targetBlockEntity.getBlockPos(), (Object)inputDirection)) != null) {
                    this.setHeatHandlerPC(heatHandler);
                }
            }
        }
    }

    public void setItemHandler(IItemHandler handler) {
        this.itemHandler = handler;
    }

    public IItemHandler getTargetHandler() {
        return this.itemHandler;
    }

    public void setFluidHandler(IFluidHandler handler) {
        this.fluidHandler = handler;
    }

    public IFluidHandler getFluidHandler() {
        return this.fluidHandler;
    }

    public void setEnergyStorage(IEnergyStorage storage) {
        this.energyStorage = storage;
    }

    public IEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public IChemicalHandler getChemicalHandler() {
        return this.chemicalHandler;
    }

    public void setChemicalHandler(IChemicalHandler handler) {
        this.chemicalHandler = handler;
    }

    public ISourceCap getSourceHandler() {
        return this.sourceStorage;
    }

    public void setSourceHandler(ISourceCap handler) {
        this.sourceStorage = handler;
    }

    public ISoulHandler getSoulHandler() {
        return this.soulHandler;
    }

    public void setSoulHandler(ISoulHandler handler) {
        this.soulHandler = handler;
    }

    public SoulNetwork getSoulNetwork() {
        return this.soulNetwork;
    }

    public void setSoulNetwork(SoulNetwork soulNetwork) {
        this.soulNetwork = soulNetwork;
    }

    public IAirHandlerMachine getPressureHandler() {
        return this.pressureHandler;
    }

    public void setPressureHandler(IAirHandlerMachine handler) {
        this.pressureHandler = handler;
    }

    public IHeatExchangerLogic getHeatHandlerPC() {
        return this.heatHandlerPC;
    }

    public void setHeatHandlerPC(IHeatExchangerLogic handler) {
        this.heatHandlerPC = handler;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider p_323910_) {
        return this.saveWithoutMetadata(p_323910_);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.loadAdditional(tag, lookupProvider);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected void saveAdditional(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        ContainerHelper.saveAllItems((CompoundTag)compoundTag, this.filters, (HolderLookup.Provider)provider);
        FluidContainerHelper.saveAllFluids(compoundTag, this.fluidFilters, true, provider);
        if (ModList.get().isLoaded("mekanism")) {
            MekanismCompat.saveChemicalFilters(compoundTag, this.chemicalFilters, provider);
        }
        if (this.extractorPos != null) {
            compoundTag.putInt("extractorX", this.extractorPos.getX());
            compoundTag.putInt("extractorY", this.extractorPos.getY());
            compoundTag.putInt("extractorZ", this.extractorPos.getZ());
        }
        compoundTag.putString("dimension", this.dimension);
    }

    protected void loadAdditional(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        ContainerHelper.loadAllItems((CompoundTag)compoundTag, this.filters, (HolderLookup.Provider)provider);
        FluidContainerHelper.loadAllFluids(compoundTag, this.fluidFilters, provider);
        if (ModList.get().isLoaded("mekanism")) {
            MekanismCompat.loadChemicalFilters(compoundTag, this.chemicalFilters, provider);
        }
        this.extractorPos = compoundTag.contains("extractorX") && compoundTag.contains("extractorY") && compoundTag.contains("extractorZ") ? new BlockPos(compoundTag.getInt("extractorX"), compoundTag.getInt("extractorY"), compoundTag.getInt("extractorZ")) : null;
        this.dimension = compoundTag.getString("dimension");
    }
}

