/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.routers.screen;

import com.benbenlaw.routers.item.FilterItem;
import com.benbenlaw.routers.item.RoutersDataComponents;
import com.benbenlaw.routers.item.RoutersItems;
import com.benbenlaw.routers.screen.ConfigMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.IModInfo;

public class ConfigScreen
extends AbstractContainerScreen<ConfigMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"routers", (String)"textures/gui/config_gui.png");
    private EditBox searchBox;
    private final List<ItemStack> previewStacks = new ArrayList<ItemStack>();
    private int previewIndex = 0;
    private long lastSwitchTime = 0L;
    private static final long SWITCH_INTERVAL = 600L;

    public ConfigScreen(ConfigMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
        this.imageHeight = 155;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    protected void init() {
        super.init();
        this.searchBox = new EditBox(this.font, this.leftPos + 30, this.topPos + 28, 120, 18, (Component)Component.literal((String)"Search"));
        this.searchBox.setMaxLength(50);
        this.searchBox.setResponder(this::onSearchChanged);
        ItemStack item = ((ConfigMenu)this.menu).player.getItemBySlot(EquipmentSlot.MAINHAND);
        if (item.is(RoutersItems.MOD_FILTER)) {
            this.searchBox.setValue((String)item.getOrDefault((DataComponentType)RoutersDataComponents.MOD_FILTER.get(), (Object)""));
        } else if (item.is(RoutersItems.TAG_FILTER)) {
            ResourceLocation tag = (ResourceLocation)item.getOrDefault((DataComponentType)RoutersDataComponents.TAG_FILTER.get(), (Object)ResourceLocation.parse((String)"set:me"));
            this.searchBox.setValue(tag.toString());
        }
        this.addRenderableWidget((GuiEventListener)this.searchBox);
        this.setInitialFocus((GuiEventListener)this.searchBox);
        this.searchBox.setFocused(true);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = this.leftPos;
        int y = this.topPos;
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        if (!this.previewStacks.isEmpty()) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastSwitchTime >= 600L) {
                this.previewIndex = (this.previewIndex + 1) % this.previewStacks.size();
                this.lastSwitchTime = currentTime;
            }
            ItemStack stackToRender = this.previewStacks.get(this.previewIndex);
            guiGraphics.renderItem(stackToRender, this.leftPos + 8, this.topPos + 29);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.searchBox.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        return this.searchBox.charTyped(codePoint, modifiers) || super.charTyped(codePoint, modifiers);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == Minecraft.getInstance().options.keyInventory.getKey().getValue()) {
            return true;
        }
        return this.searchBox.keyPressed(keyCode, scanCode, modifiers) || super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 1 && this.searchBox.isMouseOver(mouseX, mouseY)) {
            this.searchBox.setValue("");
            this.searchBox.setCursorPosition(0);
            return true;
        }
        return this.searchBox.mouseClicked(mouseX, mouseY, button) || super.mouseClicked(mouseX, mouseY, button);
    }

    private void onSearchChanged(String text) {
        ItemStack item = ((ConfigMenu)this.menu).player.getItemBySlot(EquipmentSlot.MAINHAND);
        Item item2 = item.getItem();
        if (item2 instanceof FilterItem) {
            FilterItem filterItem = (FilterItem)item2;
            String value = this.searchBox.getValue();
            boolean valid = false;
            if (item.is(RoutersItems.TAG_FILTER)) {
                TagKey tagKey;
                ResourceLocation tagLocation = ResourceLocation.tryParse((String)value);
                if (tagLocation != null && this.tagNotEmpty((TagKey<Item>)(tagKey = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)tagLocation)))) {
                    valid = true;
                    filterItem.setTag(item, tagLocation);
                }
            } else if (item.is(RoutersItems.MOD_FILTER) && this.modExists(value)) {
                valid = true;
                filterItem.setMod(item, value);
            }
            this.searchBox.setTextColor(valid ? 65280 : 0xFF5555);
            if (!valid) {
                if (item.is(RoutersItems.TAG_FILTER)) {
                    filterItem.setTag(item, ResourceLocation.tryParse((String)""));
                } else if (item.is(RoutersItems.MOD_FILTER)) {
                    filterItem.setMod(item, "");
                }
            } else {
                this.updatePreviewStacks();
            }
        }
    }

    private boolean tagNotEmpty(TagKey<Item> tagKey) {
        Optional optionalTag = BuiltInRegistries.ITEM.getTag(tagKey);
        return optionalTag.isPresent();
    }

    private boolean modExists(String modId) {
        for (IModInfo mod : ModList.get().getMods()) {
            if (!mod.getModId().equals(modId)) continue;
            return true;
        }
        return false;
    }

    private void updatePreviewStacks() {
        this.previewStacks.clear();
        ItemStack item = ((ConfigMenu)this.menu).player.getItemBySlot(EquipmentSlot.MAINHAND);
        if (item.is(RoutersItems.TAG_FILTER)) {
            ResourceLocation tagLoc = (ResourceLocation)item.getOrDefault((DataComponentType)RoutersDataComponents.TAG_FILTER.get(), (Object)Objects.requireNonNull(ResourceLocation.tryParse((String)"minecraft:stone")));
            TagKey tagKey = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)tagLoc);
            BuiltInRegistries.ITEM.getTag(tagKey).ifPresent(tagSet -> tagSet.forEach(holder -> this.previewStacks.add(new ItemStack((ItemLike)holder.value()))));
        } else if (item.is(RoutersItems.MOD_FILTER)) {
            String modId = (String)item.getOrDefault((DataComponentType)RoutersDataComponents.MOD_FILTER.get(), (Object)"");
            BuiltInRegistries.ITEM.forEach(regItem -> {
                ResourceLocation regName = BuiltInRegistries.ITEM.getKey(regItem);
                if (regName != null && regName.getNamespace().equals(modId)) {
                    this.previewStacks.add(new ItemStack((ItemLike)regItem));
                }
            });
        }
        this.previewIndex = 0;
        this.lastSwitchTime = System.currentTimeMillis();
    }
}

