/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.refinedstoragerequestify.block.tile;

import com.buuz135.refinedstoragerequestify.RSRContent;
import com.buuz135.refinedstoragerequestify.block.tile.RequesterNetworkNode;
import com.buuz135.refinedstoragerequestify.container.RequesterContainer;
import com.buuz135.refinedstoragerequestify.container.RequesterData;
import com.refinedmods.refinedstorage.api.network.impl.node.AbstractNetworkNode;
import com.refinedmods.refinedstorage.api.network.impl.node.iface.InterfaceTransferResult;
import com.refinedmods.refinedstorage.api.network.node.NetworkNode;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.network.ConnectionStrategy;
import com.refinedmods.refinedstorage.common.api.support.network.InWorldNetworkNodeContainer;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.support.FilterWithFuzzyMode;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicator;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicators;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.support.network.SimpleConnectionStrategy;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class RequesterBlockEntity
extends AbstractBaseNetworkNodeContainerBlockEntity<RequesterNetworkNode>
implements NetworkNodeExtendedMenuProvider<RequesterData> {
    private static final int EXPORT_SLOTS = 9;
    private static final String TAG_UPGRADES = "upgr";
    private final FilterWithFuzzyMode filter = FilterWithFuzzyMode.create((ResourceContainer)RequesterBlockEntity.createFilterContainer(), () -> ((RequesterBlockEntity)this).setChanged());
    private final UpgradeContainer upgradeContainer = new UpgradeContainer(4, RSRContent.REQUESTER_DESTINATION, (c, upgradeEnergyUsage) -> {
        long baseEnergyUsage = 16L;
        ((RequesterNetworkNode)this.mainNetworkNode).setEnergyUsage(16L + upgradeEnergyUsage);
        this.setChanged();
    });

    public RequesterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, (AbstractNetworkNode)new RequesterNetworkNode(16L));
        ((RequesterNetworkNode)this.mainNetworkNode).setFilter(this.filter);
        ((RequesterNetworkNode)this.mainNetworkNode).setUpgradeContainer(this.upgradeContainer);
    }

    public static ResourceContainer createFilterContainer() {
        return new ResourceContainerImpl(9, value -> Integer.MAX_VALUE, RefinedStorageApi.INSTANCE.getItemResourceFactory(), RefinedStorageApi.INSTANCE.getAlternativeResourceFactories());
    }

    public static ResourceContainer createFilterContainer(RequesterData interfaceData) {
        ResourceContainer filterContainer = RequesterBlockEntity.createFilterContainer();
        ResourceContainerData resourceContainerData = interfaceData.filterContainerData();
        for (int i = 0; i < resourceContainerData.resources().size(); ++i) {
            int ii = i;
            ((Optional)resourceContainerData.resources().get(i)).ifPresent(resource -> filterContainer.set(ii, resource));
        }
        return filterContainer;
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        if (level != null) {
            ((RequesterNetworkNode)this.mainNetworkNode).setLevel(level);
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory inventory, Player player) {
        return new RequesterContainer(syncId, player, this, this.filter.getFilterContainer(), this.upgradeContainer, this.getExportingIndicators());
    }

    public RequesterData getMenuData() {
        return new RequesterData(ResourceContainerData.of((ResourceContainer)this.filter.getFilterContainer()), this.getExportingIndicators().getAll());
    }

    public StreamEncoder<RegistryFriendlyByteBuf, RequesterData> getMenuCodec() {
        return RequesterData.STREAM_CODEC;
    }

    private ExportingIndicators getExportingIndicators() {
        return new ExportingIndicators(this.filter.getFilterContainer(), i -> this.toExportingIndicator(((RequesterNetworkNode)this.mainNetworkNode).getLastResult(i)), true);
    }

    private ExportingIndicator toExportingIndicator(@Nullable InterfaceTransferResult result) {
        InterfaceTransferResult interfaceTransferResult = result;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"STORAGE_DOES_NOT_ACCEPT_RESOURCE", "RESOURCE_MISSING", "AUTOCRAFTING_STARTED", "AUTOCRAFTING_MISSING_RESOURCES"}, (InterfaceTransferResult)interfaceTransferResult, n)) {
            case 0 -> ExportingIndicator.DESTINATION_DOES_NOT_ACCEPT_RESOURCE;
            case 1 -> ExportingIndicator.RESOURCE_MISSING;
            case 2 -> ExportingIndicator.AUTOCRAFTING_WAS_STARTED;
            case 3 -> ExportingIndicator.AUTOCRAFTING_MISSING_RESOURCES;
            default -> ExportingIndicator.NONE;
        };
    }

    public Component getName() {
        return Component.translatable((String)"block.rsrequestify.requester");
    }

    public boolean hasCustomName() {
        return false;
    }

    protected InWorldNetworkNodeContainer createMainContainer(RequesterNetworkNode networkNode) {
        return RefinedStorageApi.INSTANCE.createNetworkNodeContainer((BlockEntity)this, (NetworkNode)networkNode).connectionStrategy((ConnectionStrategy)new SimpleConnectionStrategy(this.getBlockPos())).build();
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put(TAG_UPGRADES, (Tag)ContainerUtil.write((Container)this.upgradeContainer, (HolderLookup.Provider)provider));
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        if (tag.contains(TAG_UPGRADES)) {
            ContainerUtil.read((CompoundTag)tag.getCompound(TAG_UPGRADES), (Container)this.upgradeContainer, (HolderLookup.Provider)provider);
        }
        super.loadAdditional(tag, provider);
    }

    public void writeConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeConfiguration(tag, provider);
        this.filter.save(tag, provider);
    }

    public void readConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.readConfiguration(tag, provider);
        this.filter.load(tag, provider);
    }
}

