/*
 * Decompiled with CFR 0.152.
 */
package com.schematicenergistics.widgets;

import appeng.client.gui.style.Blitter;
import appeng.items.parts.PartItem;
import com.schematicenergistics.block.CannonInterface;
import com.schematicenergistics.core.Registration;
import com.schematicenergistics.lib.SEUtils;
import com.schematicenergistics.lib.TerminalListData;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class SETerminalButton
extends AbstractWidget {
    private final Blitter buttonBg;
    private final Blitter buttonBgSelected;
    private final Consumer<Integer> onClickCallback;
    private TerminalListData data = null;
    private int itemIndex = -1;
    private boolean isSelected = false;
    private static final int TEXT_COLOR_NORMAL = 4210259;

    public SETerminalButton(int x, int y, int width, int height, Blitter buttonBg, Blitter buttonBgSelected, Consumer<Integer> onClickCallback) {
        super(x, y, width, height, (Component)Component.empty());
        this.buttonBg = buttonBg;
        this.buttonBgSelected = buttonBgSelected;
        this.onClickCallback = onClickCallback;
    }

    public void setButtonData(TerminalListData data, int index) {
        this.data = data;
        this.itemIndex = index;
        if (data != null) {
            this.visible = true;
            this.active = true;
            this.updateTooltip();
        } else {
            this.setMessage((Component)Component.empty());
            this.visible = false;
            this.active = false;
        }
    }

    public void clearData() {
        this.data = null;
        this.itemIndex = -1;
        this.isSelected = false;
        this.setMessage((Component)Component.empty());
        this.visible = false;
        this.active = false;
    }

    public void setSelected(boolean selected) {
        this.isSelected = selected;
    }

    public boolean hasData() {
        return this.data != null && this.itemIndex >= 0;
    }

    public void onClick(double mouseX, double mouseY) {
        if (this.hasData() && this.onClickCallback != null) {
            this.onClickCallback.accept(this.itemIndex);
        }
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.hasData()) {
            return;
        }
        boolean shouldHighlight = this.isHovered || this.isSelected;
        Blitter blitter = shouldHighlight ? this.buttonBgSelected : this.buttonBg;
        blitter.dest(this.getX(), this.getY()).blit(guiGraphics);
        this.renderItemIcon(guiGraphics);
        int squareEnd = this.getX() + 2 + 8;
        int iconStart = this.getX() + this.getWidth() - 12;
        int titleMaxWidth = iconStart - squareEnd - 2;
        this.renderStatusIcon(this.getX() + 3, this.getY() + 3, this.parseStateColor(this.data.state()), guiGraphics);
        this.renderText(this.handleSchematicName(this.data.schematicName()), squareEnd, this.getY() + 2, false, 0.8f, null, titleMaxWidth, guiGraphics);
        String pos = SEUtils.capitalizeFirstLetter(this.data.dimension()) + " @ " + this.data.cannonPos().toShortString();
        this.renderText(pos, this.getX() + 2, this.getY() + 12, false, 0.8f, null, 0, guiGraphics);
    }

    private void renderStatusIcon(int x, int y, int color, GuiGraphics guiGraphics) {
        int size = 3;
        guiGraphics.fill(x, y, x + size, y + size, color);
    }

    private void renderText(String text, int x, int y, boolean dropShadow, float scale, Integer color, int maxWidth, GuiGraphics guiGraphics) {
        Font font = Minecraft.getInstance().font;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(scale, scale, 1.0f);
        int textColor = color != null ? color : 4210259;
        int scaledX = (int)((float)x / scale);
        int scaledY = (int)((float)y / scale);
        int realMaxWidth = maxWidth > 0 ? maxWidth : this.getWidth() - 8;
        int scaledMaxWidth = (int)((float)realMaxWidth / scale);
        this.renderText(guiGraphics, font, text, scaledX, scaledY, scaledMaxWidth, textColor, dropShadow);
        guiGraphics.pose().popPose();
    }

    private void renderText(GuiGraphics guiGraphics, Font font, String text, int x, int y, int maxWidth, int color, boolean dropShadow) {
        if (text == null || text.isEmpty()) {
            return;
        }
        Object displayText = text;
        if (font.width(text) > maxWidth) {
            displayText = font.plainSubstrByWidth(text, maxWidth - font.width("...")) + "...";
        }
        guiGraphics.drawString(font, (String)displayText, x, y, color, dropShadow);
    }

    private void renderItemIcon(GuiGraphics guiGraphics) {
        ItemStack item;
        if (this.data == null) {
            return;
        }
        ItemStack itemStack = item = this.data.type() == SEUtils.InterfaceType.PART ? ((PartItem)Registration.CANNON_INTERFACE_PART_ITEM.get()).getDefaultInstance() : ((CannonInterface)((Object)Registration.CANNON_INTERFACE.get())).asItem().getDefaultInstance();
        if (item.isEmpty()) {
            return;
        }
        int iconX = 0;
        int iconY = 0;
        float scale = 0.75f;
        if (this.data.type() == SEUtils.InterfaceType.BLOCK) {
            iconX = this.getX() + this.getWidth() - 14;
            iconY = this.getY() + 1;
        } else {
            iconX = this.getX() + this.getWidth() - 14;
            iconY = this.getY();
        }
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)iconX, (float)iconY, 0.0f);
        guiGraphics.pose().scale(scale, scale, 1.0f);
        guiGraphics.renderItem(item, 0, 0);
        guiGraphics.pose().popPose();
    }

    private void updateTooltip() {
        String tooltipText = this.data.status() == null || this.data.status().isEmpty() ? "Status: " + Component.translatable((String)"gui.schematicenergistics.cannon_interface.missing_cannon").getString() : (this.data.schematicName() == null || this.data.schematicName().isEmpty() ? "Status: " + Component.translatable((String)"gui.schematicenergistics.cannon_interface.schematic_name").getString() : "Status: " + SEUtils.formatCannonStatus(this.data.status()).getString());
        this.setTooltip(Tooltip.create((Component)Component.literal((String)tooltipText)));
    }

    public boolean isActive() {
        return this.hasData();
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    private String handleSchematicName(String name) {
        if (name == null || name.isEmpty()) {
            return Component.translatable((String)"gui.schematicenergistics.cannon_interface.schematic_name").getString();
        }
        return name;
    }

    private int parseStateColor(String state) {
        return switch (state) {
            case "PAUSED" -> -1522101;
            case "RUNNING" -> -6160484;
            case "STOPPED" -> -2671038;
            default -> -2671038;
        };
    }
}

