/*
 * Decompiled with CFR 0.152.
 */
package net.fabric_extras.shield_api.mixin.entity.player;

import net.fabric_extras.shield_api.item.CustomShieldItem;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin
extends LivingEntity {
    @Shadow
    public abstract void awardStat(Stat<?> var1);

    @Shadow
    public abstract ItemCooldowns getCooldowns();

    protected PlayerEntityMixin(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"hurtCurrentlyUsedShield(F)V"}, at={@At(value="HEAD")})
    protected void shield_api$damageShield(float amount, CallbackInfo ci) {
        Item item = this.useItem.getItem();
        if (item instanceof CustomShieldItem) {
            CustomShieldItem customShieldItem = (CustomShieldItem)item;
            if (!this.level().isClientSide) {
                this.awardStat(Stats.ITEM_USED.get((Object)customShieldItem));
            }
            if (amount >= 3.0f) {
                int i = 1 + Mth.floor((float)amount);
                InteractionHand hand = this.getUsedItemHand();
                this.useItem.hurtAndBreak(i, (LivingEntity)this, PlayerEntityMixin.getSlotForHand((InteractionHand)hand));
                if (this.useItem.isEmpty()) {
                    if (hand == InteractionHand.MAIN_HAND) {
                        this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
                    } else {
                        this.setItemSlot(EquipmentSlot.OFFHAND, ItemStack.EMPTY);
                    }
                    this.useItem = ItemStack.EMPTY;
                    this.playSound(SoundEvents.SHIELD_BREAK, 0.8f, 0.8f + this.level().random.nextFloat() * 0.4f);
                }
            }
        }
    }

    @Inject(method={"disableShield()V"}, at={@At(value="HEAD")})
    public void shield_api$disableShield(CallbackInfo ci) {
        for (CustomShieldItem customShieldItem : CustomShieldItem.instances) {
            this.getCooldowns().addCooldown((Item)customShieldItem, 100);
        }
    }
}

