/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplylight.blocks;

import com.flanks255.simplylight.blocks.LampBase;
import com.flanks255.simplylight.network.OpenEdgeEditorPacket;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.network.PacketDistributor;

public class EdgeLight
extends LampBase
implements SimpleWaterloggedBlock {
    public final Boolean top;
    public final DyeColor color;
    public VoxelShape VS_WEST = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)0.0625, (double)0.0625, (double)1.0);
    public VoxelShape VS_EAST = Shapes.box((double)0.9375, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)1.0);
    public VoxelShape VS_SOUTH = Shapes.box((double)0.0, (double)0.0, (double)0.9375, (double)1.0, (double)0.0625, (double)1.0);
    public VoxelShape VS_NORTH = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)0.0625);
    public VoxelShape VS_ALL = Shapes.or((VoxelShape)this.VS_WEST, (VoxelShape[])new VoxelShape[]{this.VS_EAST, this.VS_NORTH, this.VS_SOUTH});
    public static final BooleanProperty NORTH = BooleanProperty.create((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.create((String)"south");
    public static final BooleanProperty EAST = BooleanProperty.create((String)"east");
    public static final BooleanProperty WEST = BooleanProperty.create((String)"west");

    public EdgeLight(Boolean top, DyeColor color) {
        super(BlockBehaviour.Properties.of().strength(1.0f).noCollission().lightLevel($ -> 14));
        this.color = color;
        this.top = top;
        if (top.booleanValue()) {
            this.VS_WEST = Shapes.box((double)0.0, (double)0.9375, (double)0.0, (double)0.0625, (double)1.0, (double)1.0);
            this.VS_EAST = Shapes.box((double)0.9375, (double)0.9375, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
            this.VS_SOUTH = Shapes.box((double)0.0, (double)0.9375, (double)0.9375, (double)1.0, (double)1.0, (double)1.0);
            this.VS_NORTH = Shapes.box((double)0.0, (double)0.9375, (double)0.0, (double)1.0, (double)1.0, (double)0.0625);
            this.VS_ALL = Shapes.or((VoxelShape)this.VS_WEST, (VoxelShape[])new VoxelShape[]{this.VS_EAST, this.VS_NORTH, this.VS_SOUTH});
        }
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    public VoxelShape getShape(BlockState pState, @Nonnull BlockGetter pLevel, @Nonnull BlockPos pPos, @Nonnull CollisionContext pContext) {
        VoxelShape shape = Shapes.empty();
        if (((Boolean)pState.getValue((Property)NORTH)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)this.VS_NORTH);
        }
        if (((Boolean)pState.getValue((Property)SOUTH)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)this.VS_SOUTH);
        }
        if (((Boolean)pState.getValue((Property)EAST)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)this.VS_EAST);
        }
        if (((Boolean)pState.getValue((Property)WEST)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)this.VS_WEST);
        }
        if (shape.isEmpty()) {
            return this.VS_ALL;
        }
        return shape;
    }

    @Nonnull
    protected InteractionResult useWithoutItem(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull BlockHitResult hitResult) {
        if (!level.isClientSide && player.isCrouching() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            byte stateByte = 0;
            stateByte = (byte)(stateByte + (byte)((Boolean)state.getValue((Property)NORTH) != false ? 1 : 0));
            stateByte = (byte)(stateByte + (byte)((Boolean)state.getValue((Property)EAST) != false ? 2 : 0));
            stateByte = (byte)(stateByte + (byte)((Boolean)state.getValue((Property)SOUTH) != false ? 4 : 0));
            stateByte = (byte)(stateByte + (byte)((Boolean)state.getValue((Property)WEST) != false ? 8 : 0));
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new OpenEdgeEditorPacket(pos, stateByte), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    public static void updateShape(Level level, BlockPos pos, byte state) {
        if (level.isClientSide) {
            return;
        }
        if (level.getBlockState(pos).getBlock() instanceof EdgeLight) {
            BlockState blockState = level.getBlockState(pos);
            blockState = (BlockState)blockState.setValue((Property)NORTH, (Comparable)Boolean.valueOf((state & 1) != 0));
            blockState = (BlockState)blockState.setValue((Property)EAST, (Comparable)Boolean.valueOf((state & 2) != 0));
            blockState = (BlockState)blockState.setValue((Property)SOUTH, (Comparable)Boolean.valueOf((state & 4) != 0));
            blockState = (BlockState)blockState.setValue((Property)WEST, (Comparable)Boolean.valueOf((state & 8) != 0));
            level.setBlockAndUpdate(pos, blockState);
        }
    }

    public boolean checkSide(BlockPlaceContext context, Direction direction) {
        BlockPos pos = context.getClickedPos().relative(direction);
        return EdgeLight.canSupportCenter((LevelReader)context.getLevel(), (BlockPos)pos, (Direction)direction.getOpposite());
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean waterlogged = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(this.checkSide(context, Direction.NORTH)))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(this.checkSide(context, Direction.SOUTH)))).setValue((Property)EAST, (Comparable)Boolean.valueOf(this.checkSide(context, Direction.EAST)))).setValue((Property)WEST, (Comparable)Boolean.valueOf(this.checkSide(context, Direction.WEST)));
    }

    public boolean canPlaceLiquid(Player pPlayer, @Nonnull BlockGetter pLevel, @Nonnull BlockPos pPos, @Nonnull BlockState pState, @Nonnull Fluid pFluid) {
        return true;
    }

    @Nonnull
    public FluidState getFluidState(BlockState pState) {
        return (Boolean)pState.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(pState);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{NORTH, SOUTH, EAST, WEST, BlockStateProperties.WATERLOGGED});
    }

    @Override
    public void addLang(BiConsumer<String, String> consumer) {
        String colorname;
        String base = this.getDescriptionId();
        DyeColor color = this.color;
        switch (color) {
            case RED: {
                String string = "Red";
                break;
            }
            case BLUE: {
                String string = "Blue";
                break;
            }
            case CYAN: {
                String string = "Cyan";
                break;
            }
            case GRAY: {
                String string = "Gray";
                break;
            }
            case LIME: {
                String string = "Lime";
                break;
            }
            case MAGENTA: {
                String string = "Magenta";
                break;
            }
            case PINK: {
                String string = "Pink";
                break;
            }
            case BLACK: {
                String string = "Black";
                break;
            }
            case BROWN: {
                String string = "Brown";
                break;
            }
            case GREEN: {
                String string = "Green";
                break;
            }
            case ORANGE: {
                String string = "Orange";
                break;
            }
            case PURPLE: {
                String string = "Purple";
                break;
            }
            case YELLOW: {
                String string = "Yellow";
                break;
            }
            case LIGHT_BLUE: {
                String string = "Light Blue";
                break;
            }
            case LIGHT_GRAY: {
                String string = "Light Gray";
                break;
            }
            default: {
                String string = colorname = "";
            }
        }
        if (color == DyeColor.WHITE) {
            consumer.accept(base, "Dynamic Edge Light (" + (this.top != false ? "top" : "bottom") + ")");
        } else {
            consumer.accept(base, "Dynamic " + colorname + " Edge Light (" + (this.top != false ? "top" : "bottom") + ")");
        }
        if (color != DyeColor.WHITE) {
            return;
        }
        consumer.accept(base + ".info", "Follows walls around itself,");
        consumer.accept(base + ".info2", "perfect for hallways.");
        consumer.accept(base + ".jei.info", "Will morph depending on the blocks present around itself on placement.\nShape will persist afterward, letting you make shapes using temporary blocks.");
    }

    @Nonnull
    public BlockState rotate(@Nonnull BlockState pState, @Nonnull Rotation pRotation) {
        if (pRotation != Rotation.NONE) {
            boolean oldNorth = (Boolean)pState.getValue((Property)NORTH);
            boolean oldSouth = (Boolean)pState.getValue((Property)SOUTH);
            boolean oldWest = (Boolean)pState.getValue((Property)WEST);
            boolean oldEast = (Boolean)pState.getValue((Property)EAST);
            if (pRotation == Rotation.CLOCKWISE_90) {
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.setValue((Property)NORTH, (Comparable)Boolean.valueOf(oldWest))).setValue((Property)EAST, (Comparable)Boolean.valueOf(oldNorth))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(oldEast))).setValue((Property)WEST, (Comparable)Boolean.valueOf(oldSouth));
            }
            if (pRotation == Rotation.CLOCKWISE_180) {
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.setValue((Property)NORTH, (Comparable)Boolean.valueOf(oldSouth))).setValue((Property)EAST, (Comparable)Boolean.valueOf(oldWest))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(oldNorth))).setValue((Property)WEST, (Comparable)Boolean.valueOf(oldEast));
            }
            if (pRotation == Rotation.COUNTERCLOCKWISE_90) {
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.setValue((Property)NORTH, (Comparable)Boolean.valueOf(oldEast))).setValue((Property)EAST, (Comparable)Boolean.valueOf(oldSouth))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(oldWest))).setValue((Property)WEST, (Comparable)Boolean.valueOf(oldNorth));
            }
        }
        return pState;
    }

    @Nonnull
    public BlockState mirror(@Nonnull BlockState pState, @Nonnull Mirror pMirror) {
        if (pMirror != Mirror.NONE) {
            boolean oldNorth = (Boolean)pState.getValue((Property)NORTH);
            boolean oldSouth = (Boolean)pState.getValue((Property)SOUTH);
            boolean oldWest = (Boolean)pState.getValue((Property)WEST);
            boolean oldEast = (Boolean)pState.getValue((Property)EAST);
            if (pMirror == Mirror.FRONT_BACK) {
                return (BlockState)((BlockState)pState.setValue((Property)WEST, (Comparable)Boolean.valueOf(oldEast))).setValue((Property)EAST, (Comparable)Boolean.valueOf(oldWest));
            }
            if (pMirror == Mirror.LEFT_RIGHT) {
                return (BlockState)((BlockState)pState.setValue((Property)NORTH, (Comparable)Boolean.valueOf(oldSouth))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(oldNorth));
            }
        }
        return pState;
    }
}

