/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplylight.util;

import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class RecipeUnlocker {
    private static String modTag;
    private static int version;

    public static void register(String modId, IEventBus bus, int recipeVersion) {
        modTag = modId + "_unlocked";
        version = recipeVersion;
        bus.addListener(RecipeUnlocker::onPlayerLoggedIn);
    }

    private static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        MinecraftServer server;
        Player player = event.getEntity();
        CompoundTag tag = player.getPersistentData();
        if (tag.contains(modTag) && tag.getInt(modTag) >= version) {
            return;
        }
        if (player instanceof ServerPlayer && (server = player.getServer()) != null) {
            ArrayList<RecipeHolder> recipes = new ArrayList<RecipeHolder>(server.getRecipeManager().getRecipes());
            recipes.removeIf(recipe -> !recipe.id().getNamespace().contains("simplylight"));
            player.awardRecipes(recipes);
            tag.putInt(modTag, version);
        }
    }
}

