/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.effect;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.effect.WideOrbitingEffect;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class ImmolationEffect
extends WideOrbitingEffect {
    public ImmolationEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
        this.particleType1 = ParticleTypes.CRIT;
        this.particleType2 = ParticleTypes.ENCHANT;
        this.yOffset = 15.0f;
    }

    @Override
    public boolean applyEffectTick(LivingEntity pLivingEntity, int pAmplifier) {
        if (!pLivingEntity.level().isClientSide() && pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            if (pLivingEntity.tickCount % 15 == 0) {
                player.level().playSound(null, (Entity)player, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_FIRE_SHOOT_FLYBY_03.get(), SoundSource.PLAYERS, 0.1f, 1.0f);
                HelperMethods.spawnParticle(player.level(), (ParticleOptions)ParticleTypes.LAVA, player.getX(), player.getY() + 0.5, player.getZ(), 0.3, 0.8, 0.2);
                HelperMethods.spawnParticle(player.level(), (ParticleOptions)ParticleTypes.LAVA, player.getX(), player.getY() + 0.5, player.getZ(), -0.2, 0.6, 0.3);
                HelperMethods.spawnParticle(player.level(), (ParticleOptions)ParticleTypes.LAVA, player.getX(), player.getY() + 0.5, player.getZ(), 0.5, 0.3, -0.2);
                HelperMethods.spawnParticle(player.level(), (ParticleOptions)ParticleTypes.SMOKE, player.getX(), player.getY() + 0.5, player.getZ(), 0.0, 0.0, 0.0);
                ItemStack checkMainStack = player.getMainHandItem();
                ItemStack checkOffStack = player.getOffhandItem();
                if (!(checkMainStack.getItem() instanceof SwordItem) && !(checkOffStack.getItem() instanceof SwordItem)) {
                    player.removeEffect(EffectRegistry.getReference(EffectRegistry.IMMOLATION));
                }
                float abilityDamage = player.getHealth() / 3.0f;
                AABB box = HelperMethods.createBox((Entity)pLivingEntity, pAmplifier);
                for (Entity entities : player.level().getEntities((Entity)player, box, EntitySelector.LIVING_ENTITY_STILL_ALIVE)) {
                    LivingEntity le;
                    if (entities == null || !(entities instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entities, (LivingEntity)player)) continue;
                    le.invulnerableTime = 0;
                    le.hurt(player.damageSources().indirectMagic((Entity)player, (Entity)player), abilityDamage);
                    le.igniteForSeconds(1.0f);
                    le.invulnerableTime = 0;
                }
            }
        }
        super.applyEffectTick(pLivingEntity, pAmplifier);
        return true;
    }

    public void removeAttributeModifiers(AttributeMap attributes) {
        super.removeAttributeModifiers(attributes);
    }

    @Override
    public boolean shouldApplyEffectTickThisTick(int pDuration, int pAmplifier) {
        return super.shouldApplyEffectTickThisTick(pDuration, pAmplifier);
    }
}

