/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record RelocationComponent(double relocateX, double relocateY, double relocateZ, UUID relocateTarget, int relocationTimer, boolean canRelocate) {
    public static RelocationComponent DEFAULT = new RelocationComponent(0.0, 0.0, 0.0, UUID.randomUUID(), 0, false);
    public static Codec<RelocationComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("x").forGetter(RelocationComponent::relocateX), (App)Codec.DOUBLE.fieldOf("y").forGetter(RelocationComponent::relocateY), (App)Codec.DOUBLE.fieldOf("z").forGetter(RelocationComponent::relocateZ), (App)UUIDUtil.AUTHLIB_CODEC.fieldOf("target").forGetter(RelocationComponent::relocateTarget), (App)Codec.INT.fieldOf("timer").forGetter(RelocationComponent::relocationTimer), (App)Codec.BOOL.fieldOf("canRelocate").forGetter(RelocationComponent::canRelocate)).apply((Applicative)instance, RelocationComponent::new));
    public static StreamCodec<RegistryFriendlyByteBuf, RelocationComponent> PACKET_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.DOUBLE, RelocationComponent::relocateX, (StreamCodec)ByteBufCodecs.DOUBLE, RelocationComponent::relocateY, (StreamCodec)ByteBufCodecs.DOUBLE, RelocationComponent::relocateZ, (StreamCodec)ByteBufCodecs.STRING_UTF8.map(UUID::fromString, UUID::toString), RelocationComponent::relocateTarget, (StreamCodec)ByteBufCodecs.INT, RelocationComponent::relocationTimer, (StreamCodec)ByteBufCodecs.BOOL, RelocationComponent::canRelocate, RelocationComponent::new);

    public boolean ready() {
        return this.relocationTimer <= 0 && this.canRelocate;
    }

    public boolean almostReady() {
        return this.relocationTimer == 40;
    }

    public RelocationComponent tickDown() {
        if (this == DEFAULT) {
            return this;
        }
        return new RelocationComponent(this.relocateX, this.relocateY, this.relocateZ, this.relocateTarget, Math.max(0, this.relocationTimer - 1), this.canRelocate);
    }

    public RelocationComponent clear() {
        return DEFAULT;
    }
}

