/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.entity.SimplySwordsAxolotlEntity;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.EntityRegistry;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public class ChompolotlSwordItem
extends UniqueSwordItem {
    public ChompolotlSwordItem(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, settings);
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.level().isClientSide()) {
            SimplySwordsAxolotlEntity axolotlEntity;
            Player player;
            ServerLevel serverWorld = (ServerLevel)attacker.level();
            int skillCooldown = Config.uniqueEffects.chompolotl.cooldown;
            float skillDamage = Config.uniqueEffects.chompolotl.damage;
            HelperMethods.playHitSounds(attacker, target);
            if (attacker instanceof Player && !(player = (Player)attacker).getCooldowns().isOnCooldown(stack.getItem()) && (axolotlEntity = (SimplySwordsAxolotlEntity)((EntityType)EntityRegistry.SIMPLYAXOLOTLENTITY.get()).spawn(serverWorld, attacker.blockPosition().above(2).relative(attacker.getMotionDirection(), 3), MobSpawnType.MOB_SUMMONED)) != null && target != null) {
                axolotlEntity.setTarget(target);
                axolotlEntity.setOwner(attacker);
                double attackDamage = 0.5 + (double)skillDamage * HelperMethods.getEntityAttackDamage(attacker);
                AttributeInstance attackAttribute = axolotlEntity.getAttribute(Attributes.ATTACK_DAMAGE);
                if (attackAttribute != null) {
                    attackAttribute.setBaseValue(attackDamage);
                }
                player.getCooldowns().addCooldown(stack.getItem(), skillCooldown);
            }
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (!world.isClientSide()) {
            SimplySwordsAxolotlEntity axolotlEntity;
            Player player;
            int skillCooldown = Config.uniqueEffects.chompolotl.cooldown;
            float skillDamage = Config.uniqueEffects.chompolotl.damage;
            ItemStack stack = user.getItemInHand(hand);
            ServerLevel serverWorld = (ServerLevel)world;
            if (user instanceof Player && !(player = user).getCooldowns().isOnCooldown(stack.getItem()) && (axolotlEntity = (SimplySwordsAxolotlEntity)((EntityType)EntityRegistry.SIMPLYAXOLOTLENTITY.get()).spawn(serverWorld, user.blockPosition().above(2).relative(user.getMotionDirection(), 3), MobSpawnType.MOB_SUMMONED)) != null) {
                AttributeInstance speedAttribute;
                axolotlEntity.setTarget((LivingEntity)user);
                axolotlEntity.setOwner((LivingEntity)user);
                axolotlEntity.setVariant(Axolotl.Variant.values()[4]);
                double attackDamage = 0.5 + (double)skillDamage * HelperMethods.getEntityAttackDamage((LivingEntity)user);
                AttributeInstance attackAttribute = axolotlEntity.getAttribute(Attributes.ATTACK_DAMAGE);
                if (attackAttribute != null) {
                    attackAttribute.setBaseValue(attackDamage);
                }
                if ((speedAttribute = axolotlEntity.getAttribute(Attributes.MOVEMENT_SPEED)) != null) {
                    speedAttribute.setBaseValue(2.0);
                }
                world.playSound(null, user.blockPosition(), (SoundEvent)SoundRegistry.ELEMENTAL_BOW_WATER_SHOOT_IMPACT_01.get(), user.getSoundSource(), 0.4f, 1.0f);
                player.getCooldowns().addCooldown(stack.getItem(), skillCooldown * 10);
            }
        }
        return super.use(world, user, hand);
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.chompolotlsworditem.tooltip1").setStyle(Styles.ABILITY));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.chompolotlsworditem.tooltip2").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.chompolotlsworditem.tooltip3").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.chompolotlsworditem.tooltip4").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.chompolotlsworditem.tooltip5").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.chompolotlsworditem.tooltip6").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.onrightclick").setStyle(Styles.RIGHT_CLICK));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.chompolotlsworditem.tooltip7").setStyle(Styles.TEXT));
        super.appendHoverText(itemStack, tooltipContext, tooltip, type);
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedInt.Restrict(min=0)
        public int cooldown;
        @ValidatedFloat.Restrict(min=0.0f)
        public float damage;
        @ValidatedFloat.Restrict(min=20.0f)
        public int duration;
        @ValidatedFloat.Restrict(min=0.0f)
        public float breedChance;
        public boolean dolphinsGrace;

        public EffectSettings() {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ItemsRegistry.CHOMPOLOTL.get();
            super(new ItemStackTooltipAppender(supplierArray));
            this.cooldown = 60;
            this.damage = 1.0f;
            this.duration = 500;
            this.breedChance = 0.0266f;
            this.dolphinsGrace = true;
        }
    }
}

