/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public class MagibladeSwordItem
extends UniqueSwordItem {
    public MagibladeSwordItem(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, settings);
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.level().isClientSide()) {
            HelperMethods.playHitSounds(attacker, target);
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.getItemInHand(hand);
        if (itemStack.getDamageValue() >= itemStack.getMaxDamage() - 1) {
            return InteractionResultHolder.fail((Object)itemStack);
        }
        user.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)itemStack);
    }

    public void onUseTick(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        if (!world.isClientSide) {
            if (remainingUseTicks % 5 == 0 && remainingUseTicks < this.getUseDuration(stack, user) - 5 && remainingUseTicks < 10) {
                this.releaseUsing(stack, world, user, remainingUseTicks);
            }
            if (remainingUseTicks == this.getUseDuration(stack, user) - 1) {
                world.playSound(null, (Entity)user, SoundEvents.WARDEN_SONIC_CHARGE, user.getSoundSource(), 0.6f, 1.4f);
            }
        }
    }

    @Override
    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 40;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (!user.level().isClientSide() && user instanceof Player) {
            Player player = (Player)user;
            int skillCooldown = Config.uniqueEffects.magiblade.cooldown;
            float damageModifier = Config.uniqueEffects.magiblade.damageModifier;
            float damage = (float)(HelperMethods.getEntityAttackDamage(user) * (double)damageModifier);
            float distance = Config.uniqueEffects.magiblade.sonicDistance;
            DamageSource damageSource = player.damageSources().playerAttack(player);
            if (remainingUseTicks < 11) {
                world.playSound(null, user.blockPosition(), SoundEvents.WARDEN_SONIC_BOOM, user.getSoundSource(), 0.8f, 1.1f);
                HelperMethods.spawnDirectionalParticles((ServerLevel)world, (ParticleOptions)ParticleTypes.SONIC_BOOM, (Entity)player, 10, distance);
                HelperMethods.damageEntitiesInTrajectory((ServerLevel)world, (Entity)player, distance, damage, damageSource);
                user.setDeltaMovement(user.getLookAngle().reverse().scale(1.1));
                user.setDeltaMovement(user.getDeltaMovement().x, 0.0, user.getDeltaMovement().z);
            }
            player.getCooldowns().addCooldown((Item)this, skillCooldown);
        }
    }

    @Override
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        HelperMethods.createFootfalls(entity, stack, world, (ParticleOptions)ParticleTypes.ENCHANT, (ParticleOptions)ParticleTypes.ENCHANT, (ParticleOptions)ParticleTypes.ASH, true);
        super.inventoryTick(stack, world, entity, slot, selected);
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.magibladesworditem.tooltip1").setStyle(Styles.ABILITY));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.magibladesworditem.tooltip2").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.magibladesworditem.tooltip3").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.magibladesworditem.tooltip4").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.onrightclickheld").setStyle(Styles.RIGHT_CLICK));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.magibladesworditem.tooltip5").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.magibladesworditem.tooltip6").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.magibladesworditem.tooltip7").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.magibladesworditem.tooltip8").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.magibladesworditem.tooltip9").setStyle(Styles.TEXT));
        super.appendHoverText(itemStack, tooltipContext, tooltip, type);
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedInt.Restrict(min=0)
        public int cooldown;
        @ValidatedFloat.Restrict(min=0.0f)
        public float damageModifier;
        @ValidatedInt.Restrict(min=0, max=100)
        public int repelChance;
        @ValidatedFloat.Restrict(min=1.0f)
        public float repelRadius;
        @ValidatedFloat.Restrict(min=1.0f)
        public float sonicDistance;

        public EffectSettings() {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ItemsRegistry.MAGIBLADE.get();
            super(new ItemStackTooltipAppender(supplierArray));
            this.cooldown = 35;
            this.damageModifier = 0.7f;
            this.repelChance = 55;
            this.repelRadius = 4.0f;
            this.sonicDistance = 16.0f;
        }
    }
}

