/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedDouble;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.client.util.TooltipUtils;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public class StealSwordItem
extends UniqueSwordItem {
    public StealSwordItem(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, settings);
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.level().isClientSide()) {
            ServerLevel sworld = (ServerLevel)attacker.level();
            int hitChance = Config.uniqueEffects.soulstealer.chance;
            int duration = Config.uniqueEffects.soulstealer.duration;
            attacker.setDeltaMovement(attacker.getLookAngle().scale(1.0));
            attacker.hurtMarked = true;
            HelperMethods.playHitSounds(attacker, target);
            if (attacker.getRandom().nextInt(100) <= hitChance) {
                int choose_sound = (int)(Math.random() * 30.0);
                if (choose_sound <= 10) {
                    sworld.playSound(null, (Entity)target, (SoundEvent)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_01.get(), target.getSoundSource(), 0.5f, 2.0f);
                } else if (choose_sound <= 20) {
                    sworld.playSound(null, (Entity)target, (SoundEvent)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_02.get(), target.getSoundSource(), 0.5f, 2.0f);
                } else {
                    sworld.playSound(null, (Entity)target, (SoundEvent)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_03.get(), target.getSoundSource(), 0.5f, 2.0f);
                }
                attacker.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, duration, 2), (Entity)attacker);
                target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, duration, 1), (Entity)attacker);
                target.addEffect(new MobEffectInstance(MobEffects.GLOWING, duration, 1), (Entity)attacker);
            }
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (!user.level().isClientSide()) {
            double sradius = Config.uniqueEffects.soulstealer.radius;
            double vradius = Config.uniqueEffects.soulstealer.radius / 2.0;
            double x = user.getX();
            double y = user.getY();
            double z = user.getZ();
            ServerLevel sworld = (ServerLevel)user.level();
            AABB box = new AABB(x + sradius, y + vradius, z + sradius, x - sradius, y - vradius, z - sradius);
            for (Entity entity : sworld.getEntities((Entity)user, box, EntitySelector.LIVING_ENTITY_STILL_ALIVE)) {
                LivingEntity le;
                if (!(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entity, (LivingEntity)user)) continue;
                int iduration = Config.uniqueEffects.soulstealer.invisDuration;
                int bduration = Config.uniqueEffects.soulstealer.blindDuration;
                if (!le.hasEffect(MobEffects.MOVEMENT_SLOWDOWN) || !le.hasEffect(MobEffects.GLOWING)) continue;
                if (le.distanceTo((Entity)user) > 5.0f) {
                    le.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, bduration, 1), (Entity)user);
                    user.randomTeleport(le.getX(), le.getY(), le.getZ(), false);
                    sworld.playSound(null, (Entity)le, (SoundEvent)SoundRegistry.ELEMENTAL_SWORD_SCIFI_ATTACK_03.get(), le.getSoundSource(), 0.3f, 1.5f);
                    float abilityDamage = HelperMethods.spellScaledDamage("soul", (Entity)user, Config.uniqueEffects.soulstealer.spellScaling, 5.0f);
                    le.hurt(user.damageSources().freeze(), abilityDamage);
                } else {
                    user.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, iduration, 1), (Entity)user);
                    user.setDeltaMovement(user.getLookAngle().scale(2.0));
                    user.hurtMarked = true;
                    sworld.playSound(null, entity, (SoundEvent)SoundRegistry.MAGIC_BOW_SHOOT_MISS_01.get(), entity.getSoundSource(), 0.3f, 1.5f);
                }
                le.removeEffect(MobEffects.MOVEMENT_SLOWDOWN);
                le.removeEffect(MobEffects.GLOWING);
            }
        }
        return super.use(world, user, hand);
    }

    @Override
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        HelperMethods.createFootfalls(entity, stack, world, (ParticleOptions)ParticleTypes.NAUTILUS, (ParticleOptions)ParticleTypes.NAUTILUS, (ParticleOptions)ParticleTypes.MYCELIUM, true);
        super.inventoryTick(stack, world, entity, slot, selected);
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.stealsworditem.tooltip1").setStyle(Styles.ABILITY));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.stealsworditem.tooltip2").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.stealsworditem.tooltip3").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.stealsworditem.tooltip4").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.onrightclick").setStyle(Styles.RIGHT_CLICK));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.stealsworditem.tooltip5").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.stealsworditem.tooltip6").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.stealsworditem.tooltip7").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.stealsworditem.tooltip8").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.stealsworditem.tooltip9").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.stealsworditem.tooltip10").setStyle(Styles.TEXT));
        super.appendHoverText(itemStack, tooltipContext, tooltip, type);
        TooltipUtils.appendSpellScaleTooltip(tooltip, "soul");
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedInt.Restrict(min=0, max=100)
        public int chance;
        @ValidatedInt.Restrict(min=0)
        public int duration;
        @ValidatedDouble.Restrict(min=1.0)
        public double radius;
        @ValidatedFloat.Restrict(min=0.0f)
        public float spellScaling;
        @ValidatedInt.Restrict(min=0)
        public int blindDuration;
        @ValidatedInt.Restrict(min=0)
        public int invisDuration;

        public EffectSettings() {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ItemsRegistry.SOULSTEALER.get();
            super(new ItemStackTooltipAppender(supplierArray));
            this.chance = 25;
            this.duration = 400;
            this.radius = 30.0;
            this.spellScaling = 2.6f;
            this.blindDuration = 200;
            this.invisDuration = 120;
        }
    }
}

