/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.client.util.TooltipUtils;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.item.component.ParryComponent;
import net.sweenus.simplyswords.registry.ComponentTypeRegistry;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public class StormbringerSwordItem
extends UniqueSwordItem {
    public static boolean scalesWithSpellPower;
    int radius = 3;
    int parrySuccession;

    public StormbringerSwordItem(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, settings);
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        HelperMethods.playHitSounds(attacker, target);
        return super.hurtEnemy(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.getItemInHand(hand);
        if (itemStack.getDamageValue() >= itemStack.getMaxDamage() - 1) {
            return InteractionResultHolder.fail((Object)itemStack);
        }
        int ability_timer_max = Config.uniqueEffects.stormbringer.blockDuration;
        ParryComponent parryComponent = (ParryComponent)itemStack.getOrDefault((DataComponentType)ComponentTypeRegistry.PARRY.get(), (Object)ParryComponent.DEFAULT);
        world.playSound(null, (Entity)user, (SoundEvent)SoundRegistry.MAGIC_SWORD_PARRY_02.get(), user.getSoundSource(), 0.8f, (float)((double)0.8f * ((double)parryComponent.parrySuccession() * 0.1)));
        user.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, ability_timer_max, 2), (Entity)user);
        user.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)itemStack);
    }

    public void onUseTick(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        if (!world.isClientSide) {
            if (remainingUseTicks <= 2) {
                user.releaseUsingItem();
            }
            AABB box = new AABB(user.getX() + (double)this.radius, user.getY() + (double)this.radius, user.getZ() + (double)this.radius, user.getX() - (double)this.radius, user.getY() - (double)this.radius, user.getZ() - (double)this.radius);
            for (Entity entity : world.getEntities((Entity)user, box, EntitySelector.LIVING_ENTITY_STILL_ALIVE)) {
                LivingEntity le;
                if (!(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entity, user) || !le.swinging || remainingUseTicks <= this.getUseDuration(stack, user) - Config.uniqueEffects.stormbringer.parryDuration) continue;
                ParryComponent parryComponent = (ParryComponent)stack.update((DataComponentType)ComponentTypeRegistry.PARRY.get(), (Object)ParryComponent.DEFAULT, ParryComponent::success);
                user.releaseUsingItem();
                le.swinging = false;
                world.playSound(null, (Entity)user, (SoundEvent)SoundRegistry.MAGIC_SWORD_PARRY_01.get(), user.getSoundSource(), 1.0f, (float)((double)0.8f * ((double)(parryComponent != null ? parryComponent.parrySuccession() : 0) * 0.1)));
            }
        }
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (!world.isClientSide) {
            int skillCooldown = Config.uniqueEffects.stormbringer.cooldown;
            ParryComponent parryComponent = (ParryComponent)stack.getOrDefault((DataComponentType)ComponentTypeRegistry.PARRY.get(), (Object)ParryComponent.DEFAULT);
            if (parryComponent.parried()) {
                AABB box = new AABB(user.getX() + (double)this.radius, user.getY() + (double)this.radius, user.getZ() + (double)this.radius, user.getX() - (double)this.radius, user.getY() - (double)this.radius, user.getZ() - (double)this.radius);
                for (Entity entities : world.getEntities((Entity)user, box, EntitySelector.LIVING_ENTITY_STILL_ALIVE)) {
                    LivingEntity le;
                    if (!(entities instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entities, user)) continue;
                    float choose = (float)(Math.random() * 1.0);
                    float abilityDamage = HelperMethods.spellScaledDamage("lightning", (Entity)user, Config.uniqueEffects.stormbringer.spellScaling, Config.uniqueEffects.stormbringer.damage);
                    le.hurt(user.damageSources().indirectMagic((Entity)user, (Entity)user), abilityDamage + (float)parryComponent.parrySuccession());
                    world.playSound(null, (Entity)le, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_POISON_ATTACK_01.get(), le.getSoundSource(), 0.3f, choose);
                    le.setDeltaMovement(le.getX() - user.getX(), 0.1, le.getZ() - user.getZ());
                    user.setDeltaMovement(le.getLookAngle().scale(1.5));
                    user.setDeltaMovement(user.getDeltaMovement().x, 0.0, user.getDeltaMovement().z);
                    user.hurtMarked = true;
                }
                world.playSound(null, (Entity)user, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_THUNDER_SHOOT_IMPACT_01.get(), user.getSoundSource(), (float)((double)0.2f * ((double)parryComponent.parrySuccession() * 0.04)), 0.8f);
                if (user instanceof Player) {
                    Player player = (Player)user;
                    player.getCooldowns().addCooldown(stack.getItem(), skillCooldown / 2 + parryComponent.parrySuccession() * 2);
                }
                stack.set((DataComponentType)ComponentTypeRegistry.PARRY.get(), (Object)parryComponent.resetParry());
            } else {
                if (user instanceof Player) {
                    Player player = (Player)user;
                    player.getCooldowns().addCooldown(stack.getItem(), skillCooldown);
                }
                stack.set((DataComponentType)ComponentTypeRegistry.PARRY.get(), (Object)parryComponent.resetFull());
            }
        }
    }

    @Override
    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return Config.uniqueEffects.stormbringer.cooldown;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    @Override
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        HelperMethods.createFootfalls(entity, stack, world, (ParticleOptions)ParticleTypes.MYCELIUM, (ParticleOptions)ParticleTypes.MYCELIUM, (ParticleOptions)ParticleTypes.MYCELIUM, true);
        super.inventoryTick(stack, world, entity, slot, selected);
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.stormbringersworditem.tooltip1").setStyle(Styles.ABILITY));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.onrightclickheld").setStyle(Styles.RIGHT_CLICK));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.stormbringersworditem.tooltip2").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.stormbringersworditem.tooltip3").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.stormbringersworditem.tooltip4").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.stormbringersworditem.tooltip5").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.stormbringersworditem.tooltip6").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.stormbringersworditem.tooltip7").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.stormbringersworditem.tooltip8").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.stormbringersworditem.tooltip9").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.stormbringersworditem.tooltip10").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.stormbringersworditem.tooltip11").setStyle(Styles.TEXT));
        super.appendHoverText(itemStack, tooltipContext, tooltip, type);
        TooltipUtils.appendSpellScaleTooltip(tooltip, "lightning");
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedInt.Restrict(min=0)
        public int cooldown;
        @ValidatedFloat.Restrict(min=0.0f)
        public float damage;
        @ValidatedFloat.Restrict(min=0.0f)
        public float spellScaling;
        @ValidatedInt.Restrict(min=0)
        public int blockDuration;
        @ValidatedInt.Restrict(min=0)
        public int parryDuration;

        public EffectSettings() {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ItemsRegistry.STORMBRINGER.get();
            super(new ItemStackTooltipAppender(supplierArray));
            this.cooldown = 90;
            this.damage = 12.0f;
            this.spellScaling = 2.3f;
            this.blockDuration = 35;
            this.parryDuration = 10;
        }
    }
}

