/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.recipe.RawUpgradableRecipe;
import net.sweenus.simplyswords.registry.RecipeTypeRegistry;

public class UpgradeUniqueRecipe
extends ShapedRecipe {
    private final int upgradableItemSlot;
    private final ItemStack result;
    private final RawUpgradableRecipe raw;

    public UpgradeUniqueRecipe(String group, CraftingBookCategory category, RawUpgradableRecipe raw, ItemStack result, boolean showNotification) {
        super(group, category, null, result, showNotification);
        this.raw = raw;
        this.result = result;
        this.upgradableItemSlot = raw.getUpgradableItemSlot();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= this.raw.getWidth() && height >= this.raw.getHeight();
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.raw.getIngredients();
    }

    public int getHeight() {
        return this.raw.getHeight();
    }

    public int getWidth() {
        return this.raw.getWidth();
    }

    public boolean matches(CraftingInput craftingRecipeInput, Level world) {
        return this.raw.matches(craftingRecipeInput);
    }

    public ItemStack assemble(CraftingInput craftingRecipeInput, HolderLookup.Provider wrapperLookup) {
        int slot = this.upgradableItemSlot;
        if (this.raw.isMirrored()) {
            int width = this.getWidth();
            int x = slot % width;
            int y = slot / width;
            slot = y * width + (width - 1 - x);
        }
        ItemStack result = this.result.copy();
        result.applyComponents(craftingRecipeInput.getItem(slot).getComponents());
        return result;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeTypeRegistry.UNIQUE_UPGRADE.get();
    }

    public static class Serializer
    implements RecipeSerializer<UpgradeUniqueRecipe> {
        public static final MapCodec<UpgradeUniqueRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(ShapedRecipe::getGroup), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(ShapedRecipe::category), (App)RawUpgradableRecipe.CODEC.forGetter(recipe -> recipe.raw), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)true).forGetter(ShapedRecipe::showNotification)).apply((Applicative)instance, UpgradeUniqueRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, UpgradeUniqueRecipe> PACKET_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        public MapCodec<UpgradeUniqueRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, UpgradeUniqueRecipe> streamCodec() {
            return PACKET_CODEC;
        }

        private static UpgradeUniqueRecipe read(RegistryFriendlyByteBuf buf) {
            String string = buf.readUtf();
            CraftingBookCategory craftingRecipeCategory = (CraftingBookCategory)buf.readEnum(CraftingBookCategory.class);
            RawUpgradableRecipe rawShapedRecipe = (RawUpgradableRecipe)RawUpgradableRecipe.PACKET_CODEC.decode((Object)buf);
            ItemStack itemStack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
            boolean bl = buf.readBoolean();
            return new UpgradeUniqueRecipe(string, craftingRecipeCategory, rawShapedRecipe, itemStack, bl);
        }

        private static void write(RegistryFriendlyByteBuf buf, UpgradeUniqueRecipe recipe) {
            buf.writeUtf(recipe.getGroup());
            buf.writeEnum((Enum)recipe.category());
            RawUpgradableRecipe.PACKET_CODEC.encode((Object)buf, (Object)recipe.raw);
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)recipe.result);
            buf.writeBoolean(recipe.showNotification());
        }
    }
}

