/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.util;

import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import org.slf4j.Logger;

public class EnchantRandomlyFromTagLootFunction
implements LootItemFunction {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final TagKey<Enchantment> tagKey;
    private HolderSet<Enchantment> enchants;

    EnchantRandomlyFromTagLootFunction(TagKey<Enchantment> tagKey) {
        this.tagKey = tagKey;
    }

    public LootItemFunctionType<? extends LootItemFunction> getType() {
        return LootItemFunctions.ENCHANT_RANDOMLY;
    }

    public ItemStack apply(ItemStack itemStack, LootContext lootContext) {
        RandomSource random;
        List list;
        Optional optional;
        if (this.enchants == null) {
            this.enchants = lootContext.getResolver().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(this.tagKey);
        }
        if ((optional = Util.getRandomSafe(list = this.enchants.stream().toList(), (RandomSource)(random = lootContext.getRandom()))).isEmpty()) {
            LOGGER.warn("Couldn't find a compatible enchantment for {}", (Object)itemStack);
            return itemStack;
        }
        return EnchantRandomlyFromTagLootFunction.addEnchantmentToStack(itemStack, (Holder<Enchantment>)((Holder)optional.get()), random);
    }

    public static Builder create(TagKey<Enchantment> tagKey) {
        return new Builder(tagKey);
    }

    private static ItemStack addEnchantmentToStack(ItemStack stack, Holder<Enchantment> enchantment, RandomSource random) {
        int i = Mth.nextInt((RandomSource)random, (int)((Enchantment)enchantment.value()).getMinLevel(), (int)((Enchantment)enchantment.value()).getMaxLevel());
        if (stack.is(Items.BOOK)) {
            stack = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
        }
        stack.enchant(enchantment, i);
        return stack;
    }

    public static class Builder
    implements LootItemFunction.Builder {
        private final TagKey<Enchantment> tagKey;

        public Builder(TagKey<Enchantment> tagKey) {
            this.tagKey = tagKey;
        }

        public LootItemFunction build() {
            return new EnchantRandomlyFromTagLootFunction(this.tagKey);
        }
    }
}

