/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.common;

import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public class DualFluidTank
implements IFluidHandler {
    protected final FluidTank[] tanks = new FluidTank[2];

    public DualFluidTank(int capacity1, int capacity2) {
        this(capacity1, capacity2, fs -> true, fs -> true);
    }

    public DualFluidTank(int capacity1, int capacity2, Predicate<FluidStack> validator1, Predicate<FluidStack> validator2) {
        this.tanks[0] = new FluidTank(capacity1, validator1){

            protected void onContentsChanged() {
                DualFluidTank.this.contentsChangedCallback();
            }
        };
        this.tanks[1] = new FluidTank(capacity2, validator2){

            protected void onContentsChanged() {
                DualFluidTank.this.contentsChangedCallback();
            }
        };
    }

    public void contentsChangedCallback() {
    }

    public int getTanks() {
        return this.tanks.length;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        this.validateTankIndex(tank);
        return this.tanks[tank].getFluid().copy();
    }

    public int getTankCapacity(int tank) {
        this.validateTankIndex(tank);
        return this.tanks[tank].getCapacity();
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        this.validateTankIndex(tank);
        return this.tanks[tank].isFluidValid(stack);
    }

    public int fill(FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return 0;
        }
        for (FluidTank tank : this.tanks) {
            int filled;
            if (!tank.isFluidValid(resource) || (filled = tank.fill(resource, action)) <= 0) continue;
            return filled;
        }
        return 0;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return FluidStack.EMPTY;
        }
        for (FluidTank tank : this.tanks) {
            FluidStack drained = tank.drain(resource, action);
            if (drained.isEmpty()) continue;
            return drained;
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(int maxDrain, @NotNull IFluidHandler.FluidAction action) {
        for (FluidTank tank : this.tanks) {
            FluidStack drained = tank.drain(maxDrain, action);
            if (drained.isEmpty()) continue;
            return drained;
        }
        return FluidStack.EMPTY;
    }

    private void validateTankIndex(int index) {
        if (index < 0 || index >= this.tanks.length) {
            throw new IndexOutOfBoundsException("Tank index out of bounds: " + index);
        }
    }

    public CompoundTag writeToNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
        CompoundTag tank0Tag = new CompoundTag();
        CompoundTag tank1Tag = new CompoundTag();
        this.tanks[0].writeToNBT(lookupProvider, tank0Tag);
        this.tanks[1].writeToNBT(lookupProvider, tank1Tag);
        nbt.put("Tank0", (Tag)tank0Tag);
        nbt.put("Tank1", (Tag)tank1Tag);
        return nbt;
    }

    public DualFluidTank readFromNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
        if (nbt.contains("Tank0")) {
            this.tanks[0].readFromNBT(lookupProvider, nbt.getCompound("Tank0"));
        }
        if (nbt.contains("Tank1", 10)) {
            this.tanks[1].readFromNBT(lookupProvider, nbt.getCompound("Tank1"));
        }
        return this;
    }

    public boolean isEmpty() {
        return this.tanks[0].getFluid().isEmpty() && this.tanks[1].getFluid().isEmpty();
    }
}

