/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.glyph;

import alexthw.starbunclemania.StarbuncleMania;
import alexthw.starbunclemania.glyph.PlaceFluidEffect;
import alexthw.starbunclemania.starbuncle.fluid.StarbyFluidBehavior;
import com.alexthw.sauce.api.WrappedExtractedItemHandler;
import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.TileCaster;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.block.tile.MobJarTile;
import com.hollingsworth.arsnouveau.common.block.tile.RuneTile;
import com.hollingsworth.arsnouveau.common.items.curios.ShapersFocus;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class PickupFluidEffect
extends AbstractEffect {
    public static final PickupFluidEffect INSTANCE = new PickupFluidEffect();

    public PickupFluidEffect() {
        super(StarbuncleMania.prefix("glyph_pickup_fluid"), "Pickup Fluid");
    }

    public String getBookDescription() {
        return "Pickups Fluids from world and fill a tank in the hotbar or next to the turret";
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Cow cow;
        Entity entity = rayTraceResult.getEntity();
        if (entity instanceof Cow && !(cow = (Cow)entity).isBaby() && !cow.hasEffect(MobEffects.HERO_OF_THE_VILLAGE)) {
            List<IFluidHandler> tanks = this.getTanks(world, spellContext);
            this.pickupCow(tanks, cow);
            for (IFluidHandler tank : tanks) {
                if (!(tank instanceof WrappedExtractedItemHandler)) continue;
                WrappedExtractedItemHandler wrap = (WrappedExtractedItemHandler)tank;
                wrap.extractedStack().returnOrDrop(world, shooter.getOnPos());
            }
        } else {
            this.onResolveBlock(new BlockHitResult(rayTraceResult.getLocation(), Direction.UP, rayTraceResult.getEntity().getOnPos(), true), world, shooter, spellStats, spellContext, resolver);
        }
    }

    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        BlockPos adjustedPos = rayTraceResult.getBlockPos();
        if (!(world.getFluidState(adjustedPos).isSource() || world.getBlockState(adjustedPos).getBlock() instanceof AbstractCauldronBlock || world.getBlockEntity(adjustedPos) instanceof MobJarTile)) {
            adjustedPos = adjustedPos.relative(rayTraceResult.getDirection());
        }
        List posList = SpellUtil.calcAOEBlocks((LivingEntity)shooter, (BlockPos)adjustedPos, (BlockHitResult)rayTraceResult, (SpellStats)spellStats);
        ANFakePlayer fakePlayer = ANFakePlayer.getPlayer((ServerLevel)((ServerLevel)world));
        List<IFluidHandler> tanks = this.getTanks(world, spellContext);
        if (tanks.isEmpty()) {
            return;
        }
        for (BlockPos pos1 : posList) {
            BlockState state = world.getBlockState(pos1);
            if (((BlockEvent.EntityPlaceEvent)NeoForge.EVENT_BUS.post((Event)new BlockEvent.EntityPlaceEvent(BlockSnapshot.create((ResourceKey)world.dimension(), (LevelAccessor)world, (BlockPos)pos1), world.getBlockState(pos1), (Entity)fakePlayer))).isCanceled()) continue;
            Block block = state.getBlock();
            if (block instanceof BucketPickup) {
                BucketPickup bp = (BucketPickup)block;
                this.pickup(pos1, (ServerLevel)world, shooter, tanks, bp, resolver, spellContext, new BlockHitResult(new Vec3((double)pos1.getX(), (double)pos1.getY(), (double)pos1.getZ()), rayTraceResult.getDirection(), pos1, false));
                continue;
            }
            if (state.hasBlockEntity() || state.getBlock() != Blocks.WATER_CAULDRON && state.getBlock() != Blocks.LAVA_CAULDRON) continue;
            this.pickupCauldron(pos1, world, shooter, tanks, resolver, spellContext, new BlockHitResult(new Vec3((double)pos1.getX(), (double)pos1.getY(), (double)pos1.getZ()), rayTraceResult.getDirection(), pos1, false));
        }
        for (IFluidHandler tank : tanks) {
            if (!(tank instanceof WrappedExtractedItemHandler)) continue;
            WrappedExtractedItemHandler wrap = (WrappedExtractedItemHandler)tank;
            wrap.extractedStack().returnOrDrop(world, shooter.getOnPos());
        }
    }

    private void pickupCauldron(BlockPos pPos, Level world, LivingEntity shooter, List<IFluidHandler> tanks, SpellResolver resolver, SpellContext spellContext, BlockHitResult resolveResult) {
        FlowingFluid fluid = world.getBlockState(pPos).getBlock() == Blocks.WATER_CAULDRON ? Fluids.WATER : Fluids.LAVA;
        for (IFluidHandler tank : tanks) {
            FluidStack tester;
            if (tank.fill(tester = new FluidStack((Fluid)fluid, 1000), IFluidHandler.FluidAction.SIMULATE) != 1000) continue;
            world.setBlockAndUpdate(pPos, Blocks.CAULDRON.defaultBlockState());
            tank.fill(tester, IFluidHandler.FluidAction.EXECUTE);
            if (tank instanceof WrappedExtractedItemHandler) {
                WrappedExtractedItemHandler wrap = (WrappedExtractedItemHandler)tank;
                wrap.updateContainer();
            }
            ShapersFocus.tryPropagateBlockSpell((BlockHitResult)resolveResult, (Level)world, (Entity)shooter, (SpellContext)spellContext, (SpellResolver)resolver);
            break;
        }
    }

    private void pickupCow(List<IFluidHandler> tanks, Cow cow) {
        for (IFluidHandler tank : tanks) {
            FluidStack tester;
            if (tank.fill(tester = new FluidStack((Fluid)NeoForgeMod.MILK.get(), 1000), IFluidHandler.FluidAction.SIMULATE) != 1000) continue;
            tank.fill(tester, IFluidHandler.FluidAction.EXECUTE);
            cow.addEffect(new MobEffectInstance(MobEffects.HERO_OF_THE_VILLAGE, 20, 1, false, false, false));
            break;
        }
    }

    private void pickup(BlockPos pPos, ServerLevel world, LivingEntity shooter, List<IFluidHandler> tanks, BucketPickup bp, SpellResolver resolver, SpellContext spellContext, BlockHitResult resolveResult) {
        FluidState fluidState = world.getFluidState(pPos);
        for (IFluidHandler tank : tanks) {
            FluidStack tester;
            if (tank.fill(tester = new FluidStack(fluidState.getType(), 1000), IFluidHandler.FluidAction.SIMULATE) != 1000 || !fluidState.isSource()) continue;
            bp.pickupBlock(this.getPlayer(shooter, world), (LevelAccessor)world, pPos, world.getBlockState(pPos));
            tank.fill(tester, IFluidHandler.FluidAction.EXECUTE);
            if (tank instanceof WrappedExtractedItemHandler) {
                WrappedExtractedItemHandler wrap = (WrappedExtractedItemHandler)tank;
                wrap.updateContainer();
            }
            ShapersFocus.tryPropagateBlockSpell((BlockHitResult)resolveResult, (Level)world, (Entity)shooter, (SpellContext)spellContext, (SpellResolver)resolver);
            break;
        }
    }

    public List<IFluidHandler> getTanks(Level world, SpellContext spellContext) {
        ArrayList<IFluidHandler> handlers;
        block3: {
            TileCaster tile;
            block4: {
                handlers = new ArrayList<IFluidHandler>();
                IWrappedCaster iWrappedCaster = spellContext.getCaster();
                if (!(iWrappedCaster instanceof TileCaster)) break block3;
                tile = (TileCaster)iWrappedCaster;
                if (!((iWrappedCaster = tile.getTile()) instanceof RuneTile)) break block4;
                RuneTile rune = (RuneTile)iWrappedCaster;
                if (rune.isSensitive) break block3;
            }
            BlockPos tilePos = tile.getTile().getBlockPos();
            for (Direction side : Direction.values()) {
                IFluidHandler handler;
                BlockPos pos = tilePos.relative(side);
                if (world.getCapability(Capabilities.FluidHandler.BLOCK, pos, (Object)side) == null || (handler = StarbyFluidBehavior.getHandlerFromCap(pos, world, side)) == null || !handler.getFluidInTank(0).isEmpty() && handler.getFluidInTank(0).getAmount() > handler.getTankCapacity(0) - 1000) continue;
                handlers.add(handler);
            }
        }
        PlaceFluidEffect.getTankItems(spellContext, handlers);
        return handlers;
    }

    public int getDefaultManaCost() {
        return 80;
    }

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    @NotNull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.MANIPULATION, SpellSchools.ELEMENTAL_WATER});
    }

    @NotNull
    protected Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentAOE.INSTANCE, AugmentPierce.INSTANCE});
    }

    public void addAugmentDescriptions(Map<AbstractAugment, String> map) {
        super.addAugmentDescriptions(map);
        this.addBlockAoeAugmentDescriptions(map);
        map.put((AbstractAugment)AugmentSensitive.INSTANCE, "Targets the block hit directly instead of the relative position.");
    }
}

