/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.starbuncle.sword;

import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.WealdWalker;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyBehavior;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class StarbyFighterBehavior
extends StarbyBehavior {
    public UUID master;
    private LivingEntity owner;
    public static final ResourceLocation TRANSPORT_ID = ResourceLocation.fromNamespaceAndPath((String)"starbunclemania", (String)"starby_fighter");

    public StarbyFighterBehavior(Starbuncle starbuncle, CompoundTag tag) {
        super(starbuncle, tag);
        if (tag.contains("master")) {
            this.master = tag.getUUID("master");
        }
        if (this.master != null) {
            this.owner = this.level.getPlayerByUUID(this.master);
        }
        this.goals.add(new WrappedGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this.starbuncle, 2.0, true)));
        this.goals.add(new WrappedGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this.starbuncle, 1.0)));
        starbuncle.targetSelector.removeAllGoals(g -> true);
        starbuncle.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)starbuncle, new Class[]{Player.class}).setAlertOthers(new Class[]{WealdWalker.class, Starbuncle.class}));
        starbuncle.targetSelector.addGoal(1, (Goal)new TargetGoal((Mob)starbuncle, false){

            public boolean canUse() {
                return StarbyFighterBehavior.this.owner != null && StarbyFighterBehavior.this.owner.getLastHurtMob() != null;
            }

            public void start() {
                StarbyFighterBehavior.this.starbuncle.setTarget(StarbyFighterBehavior.this.owner.getLastHurtMob());
                super.start();
            }
        });
        starbuncle.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)starbuncle, Mob.class, 10, false, false, entity -> {
            Mob mob;
            return entity instanceof Mob && (mob = (Mob)entity).getTarget() != null && mob.getTarget().equals((Object)this.owner) || entity != null && entity.getKillCredit() != null && entity.getKillCredit().equals((Object)this.owner);
        }));
    }

    public void onFinishedConnectionLast(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, Player playerEntity) {
        super.onFinishedConnectionLast(storedPos, storedEntity, playerEntity);
        if (storedEntity != this.starbuncle) {
            this.starbuncle.setTarget(storedEntity);
            this.syncTag();
        }
    }

    public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, Player playerEntity) {
        super.onFinishedConnectionFirst(storedPos, storedEntity, playerEntity);
        if (storedEntity != this.starbuncle) {
            this.starbuncle.setTarget(storedEntity);
            this.syncTag();
        }
    }

    public CompoundTag toTag(CompoundTag tag) {
        if (this.master != null) {
            tag.putUUID("master", this.master);
        }
        return super.toTag(tag);
    }

    public ResourceLocation getRegistryName() {
        return TRANSPORT_ID;
    }

    public ItemStack getStackForRender() {
        return ItemStack.EMPTY;
    }
}

