/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.starbuncle.trash;

import alexthw.starbunclemania.starbuncle.trash.SnatchItem;
import alexthw.starbunclemania.starbuncle.trash.VoidFromStorageGoal;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyListBehavior;
import com.hollingsworth.arsnouveau.common.items.ItemScroll;
import com.hollingsworth.arsnouveau.common.items.itemscrolls.MimicItemScroll;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StarbyVoidBehavior
extends StarbyListBehavior {
    public ItemStack itemScroll = ItemStack.EMPTY;
    public static final ResourceLocation TRANSPORT_ID = ResourceLocation.fromNamespaceAndPath((String)"starbunclemania", (String)"starby_item_void");

    public StarbyVoidBehavior(Starbuncle entity, CompoundTag tag) {
        super(entity, tag);
        if (tag.contains("itemScroll")) {
            this.itemScroll = ItemStack.parseOptional((HolderLookup.Provider)this.level.registryAccess(), (CompoundTag)tag.getCompound("itemScroll"));
        }
        this.goals.add(new WrappedGoal(3, (Goal)new SnatchItem(this.starbuncle, this)));
        this.goals.add(new WrappedGoal(3, (Goal)new VoidFromStorageGoal(this.starbuncle, this)));
    }

    @Nullable
    public IItemHandler getItemCapFromTile(@NotNull BlockPos pos, @Nullable Direction face) {
        return (IItemHandler)this.starbuncle.level().getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)face);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        Item var5 = stack.getItem();
        if (var5 instanceof ItemScroll) {
            ItemScroll scroll = (ItemScroll)var5;
            this.itemScroll = stack.copy();
            PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_nouveau.filter_set"));
            this.syncTag();
        }
        return super.mobInteract(player, hand);
    }

    public void onWanded(Player playerEntity) {
        this.itemScroll = ItemStack.EMPTY;
        super.onWanded(playerEntity);
    }

    public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable Direction face, @Nullable LivingEntity storedEntity, Player playerEntity) {
        super.onFinishedConnectionFirst(storedPos, face, storedEntity, playerEntity);
    }

    public void onFinishedConnectionLast(@Nullable BlockPos storedPos, @Nullable Direction side, @Nullable LivingEntity storedEntity, Player playerEntity) {
        super.onFinishedConnectionLast(storedPos, storedEntity, playerEntity);
        if (storedPos == null) {
            return;
        }
        if (this.starbuncle.level().getCapability(Capabilities.ItemHandler.BLOCK, storedPos, (Object)side) != null) {
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.starbuncle.take"));
            this.addFromPos(storedPos, side);
        }
    }

    public void pickUpItem(ItemEntity itemEntity) {
        super.pickUpItem(itemEntity);
        this.starbuncle.setHeldStack(ItemStack.EMPTY);
        itemEntity.remove(Entity.RemovalReason.DISCARDED);
        this.level.playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.ITEM_PICKUP, this.starbuncle.getSoundSource(), 1.0f, 1.0f);
    }

    public BlockPos getValidStorePos(ItemStack stack) {
        ItemScroll filter;
        Item item;
        if (this.itemScroll != null && (item = this.itemScroll.getItem()) instanceof ItemScroll && !((filter = (ItemScroll)item) instanceof MimicItemScroll)) {
            if (filter.getSortPref(stack, this.itemScroll, null) != ItemScroll.SortPref.INVALID) {
                return this.starbuncle.getOnPos();
            }
            return null;
        }
        return this.starbuncle.getOnPos();
    }

    @Nullable
    public BlockPos getValidTakePos() {
        if (this.FROM_LIST.isEmpty()) {
            return null;
        }
        for (BlockPos p : this.FROM_LIST) {
            if (!this.isPositionValidTake(p)) continue;
            return p;
        }
        return null;
    }

    public boolean isPositionValidTake(BlockPos p) {
        if (p == null || !this.level.isLoaded(p)) {
            return false;
        }
        Direction face = (Direction)this.FROM_DIRECTION_MAP.get(p.hashCode());
        IItemHandler iItemHandler = this.getItemCapFromTile(p, face);
        if (iItemHandler == null) {
            return false;
        }
        for (int j = 0; j < iItemHandler.getSlots(); ++j) {
            ItemStack stack = iItemHandler.getStackInSlot(j);
            if (stack.isEmpty() || this.getValidStorePos(stack) == null) continue;
            return true;
        }
        return false;
    }

    public CompoundTag toTag(CompoundTag tag) {
        super.toTag(tag);
        if (!this.itemScroll.isEmpty()) {
            tag.put("itemScroll", this.itemScroll.save((HolderLookup.Provider)this.level.registryAccess()));
        }
        return tag;
    }

    public void getTooltip(Consumer<Component> tooltip) {
        super.getTooltip(tooltip);
        tooltip.accept((Component)Component.translatable((String)"ars_nouveau.starbuncle.trashing_items", (Object[])new Object[]{this.FROM_LIST.size()}));
        if (this.itemScroll != null && !this.itemScroll.isEmpty()) {
            tooltip.accept((Component)Component.translatable((String)"ars_nouveau.filtering_with", (Object[])new Object[]{this.itemScroll.getHoverName().getString()}));
        }
    }

    public ResourceLocation getRegistryName() {
        return TRANSPORT_ID;
    }
}

