/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.structures_tweaker.compat;

import com.leclowndu93150.structures_tweaker.compat.CompatAPI;
import java.util.ArrayList;
import java.util.List;
import net.neoforged.fml.ModList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CompatManager {
    private static final Logger LOGGER = LogManager.getLogger((String)"StructuresTweaker/Compat");
    private static final List<CompatAPI> compatModules = new ArrayList<CompatAPI>();

    public static void registerCompat(CompatAPI compat) {
        compatModules.add(compat);
    }

    public static void initializeCompat() {
        LOGGER.info("Initializing compatibility modules...");
        for (CompatAPI compat : compatModules) {
            if (!ModList.get().isLoaded(compat.getModId())) continue;
            try {
                compat.initialize();
                LOGGER.info("Loaded compatibility for: {}", (Object)compat.getModId());
            }
            catch (Exception e) {
                LOGGER.error("Failed to load compatibility for {}: {}", (Object)compat.getModId(), (Object)e.getMessage());
            }
        }
    }
}

