/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.structures_tweaker.config.core;

import com.leclowndu93150.structures_tweaker.config.properties.ConfigProperty;
import com.leclowndu93150.structures_tweaker.config.properties.ConfigRegistry;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;

public class ConfigDocumentationGenerator {
    public static void generateReadmeAndDocumentation(Path configDir) {
        try {
            ConfigDocumentationGenerator.generateReadme(configDir);
            ConfigDocumentationGenerator.generateAvailableConfigs(configDir);
        }
        catch (IOException e) {
            System.err.println("Failed to generate config documentation: " + e.getMessage());
        }
    }

    private static void generateReadme(Path configDir) throws IOException {
        String content = "Structures Tweaker Configuration Guide\n=====================================\n\nThis folder contains configuration files for the Structures Tweaker mod.\n\nGLOBAL CONFIGURATION\n-------------------\nThe 'global.json' file sets default behavior for ALL structures.\nConfigure your server-wide settings here first.\n\nINDIVIDUAL STRUCTURE CONFIGS\n---------------------------\nEach structure can have its own config file in subfolders by mod:\n  - minecraft/village_plains.json\n  - dungeons_arise/shiraz_palace.json\n  - etc.\n\nThese individual files only need to contain settings that differ from\nthe global defaults. For example:\n\nglobal.json (server defaults):\n{\n  \"config\": {\n    \"canBreakBlocks\": false,\n    \"canPlaceBlocks\": false,\n    \"blockBreakWhitelist\": [\"minecraft:spawner\", \"minecraft:chest\"],\n    \"blockPlaceWhitelist\": [\"minecraft:torch\", \"minecraft:ladder\"]\n  }\n}\n\nminecraft/stronghold.json (dungeon with restrictions):\n{\n  \"individualOverrides\": {\n    \"canBreakBlocks\": false,\n    \"blockBreakBlacklist\": [\"minecraft:end_portal_frame\", \"minecraft:bedrock\"]\n  }\n}\n\nIn this setup, most structures prevent breaking/placing blocks but allow\ntorches and ladders to be placed. The stronghold specifically prevents\nbreaking the end portal frame, even if breaking becomes allowed.\n\nLIST MERGING BEHAVIOR\n---------------------\n**IMPORTANT**: List properties (whitelists/blacklists) are ADDITIVE!\nIndividual configs ADD to global lists, they don't replace them.\n\nExample:\n  Global: \"itemUseBlacklist\": [\"minecraft:flint_and_steel\"]\n  Individual: \"itemUseBlacklist\": [\"minecraft:tnt\"]\n  Result: [\"minecraft:flint_and_steel\", \"minecraft:tnt\"]\n\nThis means you can:\n- Set common restrictions in global.json\n- Add structure-specific restrictions without losing global ones\n- Build cumulative protection rules\n\nBoolean/other properties still REPLACE (not merge).\n\nHOW PRIORITY WORKS\n-----------------\nSettings are applied in this order:\n1. Individual structure config (highest priority, ADDS to lists)\n2. Global config\n3. Mod defaults (if nothing else is set)\n\nAVAILABLE SETTINGS\n-----------------\n" + ConfigDocumentationGenerator.generateSettingsDocumentation() + "\nTIPS\n----\n- Start by configuring global.json with your server's base rules\n- Only create individual configs for structures that need exceptions\n- Delete individual config files to make structures use global defaults\n- The mod automatically cleans up old/invalid settings from files\n- Changes take effect after server restart or /reload command\n- See availableconfigs.txt for a complete list of all config options\n";
        Files.writeString(configDir.resolve("README.txt"), (CharSequence)content, new OpenOption[0]);
    }

    private static void generateAvailableConfigs(Path configDir) throws IOException {
        StringBuilder content = new StringBuilder();
        content.append("Available Configuration Options\n");
        content.append("===============================\n\n");
        content.append("This file is automatically generated and shows all available config options.\n\n");
        for (ConfigProperty<?> property : ConfigRegistry.getAllProperties().values()) {
            content.append(String.format("%-25s: %s (default: %s)\n", property.getKey(), property.getDescription(), property.getDefaultValue()));
        }
        content.append("\nExample JSON usage:\n");
        content.append("{\n");
        content.append("  \"config\": {\n");
        boolean first = true;
        for (ConfigProperty<?> property : ConfigRegistry.getAllProperties().values()) {
            if (!first) {
                content.append(",\n");
            }
            content.append(String.format("    \"%s\": %s", property.getKey(), ConfigDocumentationGenerator.formatDefaultValue(property.getDefaultValue())));
            first = false;
        }
        content.append("\n  }\n");
        content.append("}\n");
        Files.writeString(configDir.resolve("availableconfigs.txt"), (CharSequence)content.toString(), new OpenOption[0]);
    }

    private static String generateSettingsDocumentation() {
        StringBuilder sb = new StringBuilder();
        for (ConfigProperty<?> property : ConfigRegistry.getAllProperties().values()) {
            sb.append(String.format("- %-20s: %s (default: %s)\n", property.getKey(), property.getDescription(), property.getDefaultValue()));
        }
        return sb.toString();
    }

    private static String formatDefaultValue(Object value) {
        if (value instanceof String) {
            return "\"" + String.valueOf(value) + "\"";
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof Number) {
            return value.toString();
        }
        if (value instanceof List) {
            List list = (List)value;
            if (list.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder("[");
            boolean first = true;
            for (Object item : list) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append("\"").append(item).append("\"");
                first = false;
            }
            sb.append("]");
            return sb.toString();
        }
        return "\"" + String.valueOf(value) + "\"";
    }
}

