/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.structures_tweaker.config.presets;

import com.leclowndu93150.structures_tweaker.config.core.ModularStructureConfig;
import com.leclowndu93150.structures_tweaker.config.properties.ConfigProperty;
import com.leclowndu93150.structures_tweaker.config.properties.ConfigRegistry;
import java.util.HashMap;
import java.util.Map;

public class StructureConfigPresets {
    private static final Map<String, Map<String, Map<ConfigProperty<?>, Object>>> MOD_PRESETS = new HashMap();

    public static void registerPreset(String modId, String structureId, Map<ConfigProperty<?>, Object> changes) {
        HashMap changesCopy = new HashMap(changes);
        MOD_PRESETS.computeIfAbsent(modId, k -> new HashMap()).put(structureId, changesCopy);
    }

    public static ModularStructureConfig createPreset(Map<ConfigProperty<?>, Object> changes) {
        ModularStructureConfig config = new ModularStructureConfig();
        for (Map.Entry<ConfigProperty<?>, Object> entry : changes.entrySet()) {
            config.setValue(entry.getKey().getKey(), entry.getValue());
        }
        return config;
    }

    public static ModularStructureConfig getPreset(String modId, String structureId) {
        Map<ConfigProperty<?>, Object> changes;
        Map<String, Map<ConfigProperty<?>, Object>> modPresets = MOD_PRESETS.get(modId);
        if (modPresets != null && (changes = modPresets.get(structureId)) != null) {
            ModularStructureConfig config = new ModularStructureConfig();
            for (Map.Entry<ConfigProperty<?>, Object> entry : changes.entrySet()) {
                config.setValue(entry.getKey().getKey(), entry.getValue());
            }
            return config;
        }
        return null;
    }

    public static Map<ConfigProperty<?>, Object> getPresetChanges(String modId, String structureId) {
        Map<String, Map<ConfigProperty<?>, Object>> modPresets = MOD_PRESETS.get(modId);
        if (modPresets != null) {
            return modPresets.get(structureId);
        }
        return null;
    }

    static {
        HashMap protectedSpawnerChanges = new HashMap();
        protectedSpawnerChanges.put(ConfigRegistry.CAN_BREAK_BLOCKS, false);
        protectedSpawnerChanges.put(ConfigRegistry.CAN_INTERACT, true);
        protectedSpawnerChanges.put(ConfigRegistry.CAN_PLACE_BLOCKS, false);
        protectedSpawnerChanges.put(ConfigRegistry.ALLOW_PLAYER_PVP, true);
        protectedSpawnerChanges.put(ConfigRegistry.ALLOW_CREATURE_SPAWNING, true);
        protectedSpawnerChanges.put(ConfigRegistry.ALLOW_FIRE_SPREAD, true);
        protectedSpawnerChanges.put(ConfigRegistry.ALLOW_EXPLOSIONS, true);
        protectedSpawnerChanges.put(ConfigRegistry.ALLOW_ITEM_PICKUP, true);
        protectedSpawnerChanges.put(ConfigRegistry.ONLY_PROTECT_ORIGINAL_BLOCKS, false);
        protectedSpawnerChanges.put(ConfigRegistry.ALLOW_ELYTRA_FLIGHT, false);
        protectedSpawnerChanges.put(ConfigRegistry.ALLOW_ENDER_PEARLS, false);
        protectedSpawnerChanges.put(ConfigRegistry.ALLOW_RIPTIDE, false);
        StructureConfigPresets.registerPreset("das", "deep_fortress", protectedSpawnerChanges);
        StructureConfigPresets.registerPreset("das", "deep_spawner_1", protectedSpawnerChanges);
        StructureConfigPresets.registerPreset("das", "deep_spawner_2", protectedSpawnerChanges);
        StructureConfigPresets.registerPreset("das", "deep_spawner_3", protectedSpawnerChanges);
        StructureConfigPresets.registerPreset("uas", "carousel_spawner_1", protectedSpawnerChanges);
        StructureConfigPresets.registerPreset("uas", "carousel_spawner_2", protectedSpawnerChanges);
        StructureConfigPresets.registerPreset("uas", "carousel_spawner_3", protectedSpawnerChanges);
        StructureConfigPresets.registerPreset("uas", "garden_fortress", protectedSpawnerChanges);
    }

    public static class PresetBuilder {
        private final Map<ConfigProperty<?>, Object> changes = new HashMap();

        public PresetBuilder with(ConfigProperty<?> property, Object value) {
            this.changes.put(property, value);
            return this;
        }

        public Map<ConfigProperty<?>, Object> build() {
            return new HashMap(this.changes);
        }
    }
}

