/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.structures_tweaker.config.properties;

import com.leclowndu93150.structures_tweaker.config.properties.ConfigProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ConfigRegistry {
    private static final Map<String, ConfigProperty<?>> PROPERTIES = new LinkedHashMap();
    private static final List<ConfigPropertyRegistration> REGISTRATIONS = new ArrayList<ConfigPropertyRegistration>();
    public static final ConfigProperty<Boolean> CAN_BREAK_BLOCKS = ConfigRegistry.register("canBreakBlocks", true, Boolean.class, "Allow breaking blocks in structure");
    public static final ConfigProperty<Boolean> CAN_INTERACT = ConfigRegistry.register("canInteract", true, Boolean.class, "Allow interaction with blocks");
    public static final ConfigProperty<Boolean> CAN_PLACE_BLOCKS = ConfigRegistry.register("canPlaceBlocks", true, Boolean.class, "Allow placing blocks in structure");
    public static final ConfigProperty<Boolean> ALLOW_PLAYER_PVP = ConfigRegistry.register("allowPlayerPVP", true, Boolean.class, "Allow PVP in structure");
    public static final ConfigProperty<Boolean> ALLOW_CREATURE_SPAWNING = ConfigRegistry.register("allowCreatureSpawning", true, Boolean.class, "Allow mob spawning in structure");
    public static final ConfigProperty<Boolean> PREVENT_HOSTILE_SPAWNS = ConfigRegistry.register("preventHostileSpawns", false, Boolean.class, "Prevent hostile mob spawning in structure");
    public static final ConfigProperty<Boolean> PREVENT_PASSIVE_SPAWNS = ConfigRegistry.register("preventPassiveSpawns", false, Boolean.class, "Prevent passive mob spawning in structure");
    public static final ConfigProperty<Boolean> ALLOW_FIRE_SPREAD = ConfigRegistry.register("allowFireSpread", true, Boolean.class, "Allow fire to spread in structure");
    public static final ConfigProperty<Boolean> ALLOW_EXPLOSIONS = ConfigRegistry.register("allowExplosions", true, Boolean.class, "Allow explosions in structure");
    public static final ConfigProperty<Boolean> ALLOW_ITEM_PICKUP = ConfigRegistry.register("allowItemPickup", true, Boolean.class, "Allow picking up items in structure");
    public static final ConfigProperty<Boolean> ONLY_PROTECT_ORIGINAL_BLOCKS = ConfigRegistry.register("onlyProtectOriginalBlocks", false, Boolean.class, "Only protect blocks that were part of the original structure");
    public static final ConfigProperty<Boolean> ALLOW_ELYTRA_FLIGHT = ConfigRegistry.register("allowElytraFlight", true, Boolean.class, "Allow elytra flight in structure");
    public static final ConfigProperty<Boolean> ALLOW_ENDER_PEARLS = ConfigRegistry.register("allowEnderPearls", true, Boolean.class, "Allow ender pearl usage in structure");
    public static final ConfigProperty<Boolean> ALLOW_RIPTIDE = ConfigRegistry.register("allowRiptide", true, Boolean.class, "Allow riptide trident usage in structure");
    public static final ConfigProperty<Boolean> ALLOW_CREATIVE_FLIGHT = ConfigRegistry.register("allowCreativeFlight", true, Boolean.class, "Allow creative flight in structure");
    public static final ConfigProperty<Boolean> ALLOW_ENDER_TELEPORTATION = ConfigRegistry.register("allowEnderTeleportation", true, Boolean.class, "Allow all ender-based teleportation (pearls, chorus fruit) in structure");
    public static final ConfigProperty<Boolean> CREATIVE_BYPASS = ConfigRegistry.register("creativeBypass", false, Boolean.class, "Allow creative mode players to bypass player restrictions");
    public static final ConfigProperty<Boolean> PREVENT_MOB_GRIEFING = ConfigRegistry.register("preventMobGriefing", false, Boolean.class, "Prevent mob griefing (e.g., creeper explosions, enderman block picking, wither destruction) in structure");
    public static final ConfigProperty<List<String>> INTERACTION_WHITELIST = ConfigRegistry.registerList("interactionWhitelist", new ArrayList<String>(), "Blocks that can always be interacted with (e.g., minecraft:lever, minecraft:button)");
    public static final ConfigProperty<List<String>> INTERACTION_BLACKLIST = ConfigRegistry.registerList("interactionBlacklist", new ArrayList<String>(), "Blocks that can never be interacted with (e.g., minecraft:repeater, minecraft:comparator)");
    public static final ConfigProperty<List<String>> ITEM_USE_BLACKLIST = ConfigRegistry.registerList("itemUseBlacklist", new ArrayList<String>(), "Items that cannot be used in the structure (e.g., minecraft:boat, minecraft:water_bucket)");
    public static final ConfigProperty<List<String>> ITEM_USE_WHITELIST = ConfigRegistry.registerList("itemUseWhitelist", new ArrayList<String>(), "Items that can always be used in the structure, overrides blacklist");
    public static final ConfigProperty<List<String>> BLOCK_BREAK_WHITELIST = ConfigRegistry.registerList("blockBreakWhitelist", new ArrayList<String>(), "Blocks that can always be broken, overrides canBreakBlocks restriction (e.g., minecraft:spawner, minecraft:chest)");
    public static final ConfigProperty<List<String>> BLOCK_BREAK_BLACKLIST = ConfigRegistry.registerList("blockBreakBlacklist", new ArrayList<String>(), "Blocks that can never be broken, even if canBreakBlocks is true (e.g., minecraft:bedrock, minecraft:barrier)");
    public static final ConfigProperty<List<String>> BLOCK_PLACE_WHITELIST = ConfigRegistry.registerList("blockPlaceWhitelist", new ArrayList<String>(), "Blocks that can always be placed, overrides canPlaceBlocks restriction (e.g., minecraft:torch, minecraft:ladder)");
    public static final ConfigProperty<List<String>> BLOCK_PLACE_BLACKLIST = ConfigRegistry.registerList("blockPlaceBlacklist", new ArrayList<String>(), "Blocks that can never be placed, even if canPlaceBlocks is true (e.g., minecraft:tnt, minecraft:wither_skeleton_skull)");

    public static <T> ConfigProperty<T> register(String key, T defaultValue, Class<T> type, String description) {
        ConfigProperty<T> property = new ConfigProperty<T>(key, defaultValue, type, description);
        PROPERTIES.put(key, property);
        REGISTRATIONS.add(new ConfigPropertyRegistration(key, System.currentTimeMillis()));
        return property;
    }

    public static ConfigProperty<List<String>> registerList(String key, List<String> defaultValue, String description) {
        ConfigProperty<List<String>> property = new ConfigProperty<List<String>>(key, defaultValue, List.class, description);
        PROPERTIES.put(key, property);
        REGISTRATIONS.add(new ConfigPropertyRegistration(key, System.currentTimeMillis()));
        return property;
    }

    public static Map<String, ConfigProperty<?>> getAllProperties() {
        return Collections.unmodifiableMap(PROPERTIES);
    }

    public static ConfigProperty<?> getProperty(String key) {
        return PROPERTIES.get(key);
    }

    public static List<String> getPropertyKeys() {
        return new ArrayList<String>(PROPERTIES.keySet());
    }

    public static List<ConfigPropertyRegistration> getRegistrationHistory() {
        return Collections.unmodifiableList(REGISTRATIONS);
    }

    public static class ConfigPropertyRegistration {
        public final String key;
        public final long timestamp;

        public ConfigPropertyRegistration(String key, long timestamp) {
            this.key = key;
            this.timestamp = timestamp;
        }
    }
}

