/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.structures_tweaker.events;

import com.leclowndu93150.structures_tweaker.config.core.StructureConfig;
import com.leclowndu93150.structures_tweaker.config.properties.ConfigProperty;
import com.leclowndu93150.structures_tweaker.config.properties.ConfigRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DynamicStructureFlags {
    private final Map<String, Object> flags = new HashMap<String, Object>();

    public DynamicStructureFlags(StructureConfig config) {
        for (ConfigProperty<?> property : ConfigRegistry.getAllProperties().values()) {
            this.flags.put(property.getKey(), config.getValue(property));
        }
    }

    public <T> T getValue(ConfigProperty<T> property) {
        Object value = this.flags.get(property.getKey());
        if (value == null) {
            return property.getDefaultValue();
        }
        return property.convert(value);
    }

    public boolean canBreakBlocks() {
        return this.getValue(ConfigRegistry.CAN_BREAK_BLOCKS);
    }

    public boolean canInteract() {
        return this.getValue(ConfigRegistry.CAN_INTERACT);
    }

    public boolean canPlaceBlocks() {
        return this.getValue(ConfigRegistry.CAN_PLACE_BLOCKS);
    }

    public boolean allowPlayerPVP() {
        return this.getValue(ConfigRegistry.ALLOW_PLAYER_PVP);
    }

    public boolean allowCreatureSpawning() {
        return this.getValue(ConfigRegistry.ALLOW_CREATURE_SPAWNING);
    }

    public boolean allowFireSpread() {
        return this.getValue(ConfigRegistry.ALLOW_FIRE_SPREAD);
    }

    public boolean allowExplosions() {
        return this.getValue(ConfigRegistry.ALLOW_EXPLOSIONS);
    }

    public boolean allowItemPickup() {
        return this.getValue(ConfigRegistry.ALLOW_ITEM_PICKUP);
    }

    public boolean onlyProtectOriginalBlocks() {
        return this.getValue(ConfigRegistry.ONLY_PROTECT_ORIGINAL_BLOCKS);
    }

    public boolean allowElytraFlight() {
        return this.getValue(ConfigRegistry.ALLOW_ELYTRA_FLIGHT);
    }

    public boolean allowEnderPearls() {
        return this.getValue(ConfigRegistry.ALLOW_ENDER_PEARLS);
    }

    public boolean allowRiptide() {
        return this.getValue(ConfigRegistry.ALLOW_RIPTIDE);
    }

    public boolean allowCreativeFlight() {
        return this.getValue(ConfigRegistry.ALLOW_CREATIVE_FLIGHT);
    }

    public boolean allowEnderTeleportation() {
        return this.getValue(ConfigRegistry.ALLOW_ENDER_TELEPORTATION);
    }

    public boolean preventHostileSpawns() {
        return this.getValue(ConfigRegistry.PREVENT_HOSTILE_SPAWNS);
    }

    public boolean preventPassiveSpawns() {
        return this.getValue(ConfigRegistry.PREVENT_PASSIVE_SPAWNS);
    }

    public boolean creativeBypass() {
        return this.getValue(ConfigRegistry.CREATIVE_BYPASS);
    }

    public boolean preventMobGriefing() {
        return this.getValue(ConfigRegistry.PREVENT_MOB_GRIEFING);
    }

    public List<String> getInteractionWhitelist() {
        return this.getValue(ConfigRegistry.INTERACTION_WHITELIST);
    }

    public List<String> getInteractionBlacklist() {
        return this.getValue(ConfigRegistry.INTERACTION_BLACKLIST);
    }

    public List<String> getItemUseBlacklist() {
        return this.getValue(ConfigRegistry.ITEM_USE_BLACKLIST);
    }

    public List<String> getItemUseWhitelist() {
        return this.getValue(ConfigRegistry.ITEM_USE_WHITELIST);
    }

    public List<String> getBlockBreakWhitelist() {
        return this.getValue(ConfigRegistry.BLOCK_BREAK_WHITELIST);
    }

    public List<String> getBlockBreakBlacklist() {
        return this.getValue(ConfigRegistry.BLOCK_BREAK_BLACKLIST);
    }

    public List<String> getBlockPlaceWhitelist() {
        return this.getValue(ConfigRegistry.BLOCK_PLACE_WHITELIST);
    }

    public List<String> getBlockPlaceBlacklist() {
        return this.getValue(ConfigRegistry.BLOCK_PLACE_BLACKLIST);
    }

    public Map<String, Object> getAllFlags() {
        return new HashMap<String, Object>(this.flags);
    }
}

