/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.structures_tweaker.events;

import com.leclowndu93150.baguettelib.event.entity.CreativeFlightEvent;
import com.leclowndu93150.structures_tweaker.cache.StructureCache;
import com.leclowndu93150.structures_tweaker.config.core.StructureConfig;
import com.leclowndu93150.structures_tweaker.config.core.StructureConfigManager;
import com.leclowndu93150.structures_tweaker.data.DefeatedStructuresData;
import com.leclowndu93150.structures_tweaker.data.EmptyChunksData;
import com.leclowndu93150.structures_tweaker.data.StructureBlocksData;
import com.leclowndu93150.structures_tweaker.events.DynamicStructureFlags;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.EntityMobGriefingEvent;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;
import net.neoforged.neoforge.event.entity.living.MobSpawnEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StructureEventHandler {
    private final StructureConfigManager configManager;
    private final StructureCache structureCache;
    public final Map<ResourceLocation, DynamicStructureFlags> structureFlags;
    private int tickCounter = 0;
    private static final Logger LOGGER = LogManager.getLogger((String)"structures_tweaker");
    private static StructureEventHandler INSTANCE;

    public StructureEventHandler(StructureConfigManager configManager, StructureCache structureCache) {
        this.configManager = configManager;
        this.structureCache = structureCache;
        this.structureFlags = new ConcurrentHashMap<ResourceLocation, DynamicStructureFlags>();
    }

    public void reloadFlags() {
        this.structureFlags.clear();
        this.configManager.getAllConfigs().forEach((id, config) -> {
            ResourceLocation normalizedId = this.normalizeStructureId((ResourceLocation)id);
            this.structureFlags.put(normalizedId, new DynamicStructureFlags((StructureConfig)config));
        });
    }

    public void updateStructureFlag(ResourceLocation structureId, StructureConfig config) {
        ResourceLocation normalizedId = this.normalizeStructureId(structureId);
        this.structureFlags.put(normalizedId, new DynamicStructureFlags(config));
        LOGGER.info("Updated structure flags for {}", (Object)normalizedId);
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (!this.configManager.isReady()) {
            return;
        }
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)levelAccessor;
        this.handleStructureEvent(event.getPlayer().level(), event.getPos(), event.getPlayer(), (structure, flags) -> {
            Block block = event.getState().getBlock();
            ResourceLocation blockId = event.getPlayer().level().registryAccess().registryOrThrow(Registries.BLOCK).getKey((Object)block);
            if (blockId != null) {
                String blockIdStr = blockId.toString();
                List<String> whitelist = flags.getBlockBreakWhitelist();
                if (whitelist != null && !whitelist.isEmpty() && whitelist.contains(blockIdStr)) {
                    return false;
                }
                List<String> blacklist = flags.getBlockBreakBlacklist();
                if (blacklist != null && !blacklist.isEmpty() && blacklist.contains(blockIdStr)) {
                    event.setCanceled(true);
                    return true;
                }
            }
            StructureBlocksData blockData = StructureBlocksData.get(serverLevel);
            if (flags.onlyProtectOriginalBlocks()) {
                if (blockData.isPlayerPlaced(event.getPos())) {
                    blockData.removePlayerBlock(event.getPos());
                    return false;
                }
                event.setCanceled(true);
                return true;
            }
            if (!flags.canBreakBlocks()) {
                event.setCanceled(true);
                return true;
            }
            return false;
        });
    }

    @SubscribeEvent
    public void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        Player player;
        Entity entity;
        block5: {
            block4: {
                if (event.getLevel().isClientSide() || !((entity = event.getEntity()) instanceof Player)) break block4;
                player = (Player)entity;
                entity = event.getLevel();
                if (entity instanceof ServerLevel) break block5;
            }
            return;
        }
        ServerLevel serverLevel = (ServerLevel)entity;
        if (!this.configManager.isReady()) {
            return;
        }
        this.handleStructureEvent(Objects.requireNonNull(event.getEntity()).level(), event.getPos(), player, (structure, flags) -> {
            Block block = event.getPlacedBlock().getBlock();
            ResourceLocation blockId = event.getEntity().level().registryAccess().registryOrThrow(Registries.BLOCK).getKey((Object)block);
            if (blockId != null) {
                String blockIdStr = blockId.toString();
                List<String> whitelist = flags.getBlockPlaceWhitelist();
                if (whitelist != null && !whitelist.isEmpty() && whitelist.contains(blockIdStr)) {
                    if (!event.isCanceled()) {
                        StructureBlocksData blockData = StructureBlocksData.get(serverLevel);
                        blockData.addPlayerBlock((ResourceLocation)structure, event.getPos());
                    }
                    return false;
                }
                List<String> blacklist = flags.getBlockPlaceBlacklist();
                if (blacklist != null && !blacklist.isEmpty() && blacklist.contains(blockIdStr)) {
                    event.setCanceled(true);
                    return true;
                }
            }
            if (event.getPlacedBlock().getBlock() == Blocks.FIRE) {
                if (!flags.allowFireSpread()) {
                    event.setCanceled(true);
                    return true;
                }
            } else if (!flags.canPlaceBlocks()) {
                event.setCanceled(true);
                return true;
            }
            if (!event.isCanceled()) {
                StructureBlocksData blockData = StructureBlocksData.get(serverLevel);
                blockData.addPlayerBlock((ResourceLocation)structure, event.getPos());
            }
            return false;
        });
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        if (!this.configManager.isReady()) {
            return;
        }
        this.handleStructureEvent(event.getLevel(), event.getPos(), event.getEntity(), (structure, flags) -> {
            Block block = event.getLevel().getBlockState(event.getPos()).getBlock();
            ResourceLocation blockId = event.getLevel().registryAccess().registryOrThrow(Registries.BLOCK).getKey((Object)block);
            if (blockId != null) {
                String blockIdStr = blockId.toString();
                List<String> whitelist = flags.getInteractionWhitelist();
                if (whitelist != null && !whitelist.isEmpty() && whitelist.contains(blockIdStr)) {
                    return false;
                }
                List<String> blacklist = flags.getInteractionBlacklist();
                if (blacklist != null && !blacklist.isEmpty() && blacklist.contains(blockIdStr)) {
                    event.setCanceled(true);
                    return true;
                }
            }
            if (!flags.canInteract()) {
                Item patt0$temp = event.getItemStack().getItem();
                if (patt0$temp instanceof BlockItem) {
                    List<String> placeWhitelist;
                    BlockItem blockItem = (BlockItem)patt0$temp;
                    ResourceLocation itemBlockId = event.getLevel().registryAccess().registryOrThrow(Registries.BLOCK).getKey((Object)blockItem.getBlock());
                    if (itemBlockId != null && (placeWhitelist = flags.getBlockPlaceWhitelist()) != null && !placeWhitelist.isEmpty() && placeWhitelist.contains(itemBlockId.toString())) {
                        event.setUseBlock(TriState.FALSE);
                        event.setUseItem(TriState.TRUE);
                        return false;
                    }
                }
                event.setCanceled(true);
                return true;
            }
            return false;
        });
    }

    @SubscribeEvent
    public void onExplosion(ExplosionEvent.Start event) {
        if (event.getLevel().isClientSide() || !this.configManager.isReady()) {
            return;
        }
        Entity source = event.getExplosion().getDirectSourceEntity();
        BlockPos pos = source != null ? source.blockPosition() : new BlockPos((int)event.getExplosion().x, (int)event.getExplosion().y, (int)event.getExplosion().z);
        this.handleStructureEvent(event.getLevel(), pos, (structure, flags) -> {
            if (!flags.allowExplosions()) {
                event.setCanceled(true);
                return true;
            }
            return false;
        });
    }

    @SubscribeEvent
    public void onPositionCheck(MobSpawnEvent.PositionCheck event) {
        if (event.getSpawnType() == MobSpawnType.SPAWNER || event.getSpawnType() == MobSpawnType.SPAWN_EGG || event.getSpawnType() == MobSpawnType.COMMAND) {
            return;
        }
        Mob entity = event.getEntity();
        ServerLevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof Level)) {
            return;
        }
        Level level = (Level)levelAccessor;
        BlockPos pos = entity.blockPosition();
        this.handleStructureEvent(level, pos, (structure, flags) -> {
            if (!flags.allowCreatureSpawning()) {
                event.setResult(MobSpawnEvent.PositionCheck.Result.FAIL);
                return true;
            }
            MobCategory category = entity.getType().getCategory();
            if (flags.preventHostileSpawns() && this.isHostileMob(category)) {
                event.setResult(MobSpawnEvent.PositionCheck.Result.FAIL);
                return true;
            }
            if (flags.preventPassiveSpawns() && this.isPassiveMob(category)) {
                event.setResult(MobSpawnEvent.PositionCheck.Result.FAIL);
                return true;
            }
            return false;
        });
    }

    private boolean isHostileMob(MobCategory category) {
        return category == MobCategory.MONSTER || category == MobCategory.UNDERGROUND_WATER_CREATURE;
    }

    private boolean isPassiveMob(MobCategory category) {
        return category == MobCategory.CREATURE || category == MobCategory.WATER_CREATURE || category == MobCategory.AMBIENT || category == MobCategory.AXOLOTLS || category == MobCategory.WATER_AMBIENT;
    }

    @SubscribeEvent
    public void onPlayerPvP(AttackEntityEvent event) {
        Player player;
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        if (!this.configManager.isReady()) {
            return;
        }
        if (event.getTarget() instanceof Player && (player = event.getEntity()) instanceof Player) {
            Player player2 = player;
            this.handleStructureEvent(event.getEntity().level(), event.getEntity().blockPosition(), player2, (structure, flags) -> {
                if (!flags.allowPlayerPVP()) {
                    event.setCanceled(true);
                    return true;
                }
                return false;
            });
        }
    }

    @SubscribeEvent
    public void onItemPickup(ItemEntityPickupEvent.Pre event) {
        if (!this.configManager.isReady()) {
            return;
        }
        ItemEntity item = event.getItemEntity();
        this.handleStructureEvent(item.level(), item.blockPosition(), event.getPlayer(), (structure, flags) -> {
            if (!flags.allowItemPickup()) {
                event.setCanPickup(TriState.FALSE);
                return true;
            }
            return false;
        });
    }

    @SubscribeEvent
    public void onServerStopped(ServerStoppedEvent event) {
        this.structureFlags.clear();
    }

    public void handleStructureEvent(Level level, BlockPos pos, BiPredicate<ResourceLocation, DynamicStructureFlags> callback) {
        this.handleStructureEvent(level, pos, null, callback);
    }

    public void handleStructureEvent(Level level, BlockPos pos, @Nullable Player player, BiPredicate<ResourceLocation, DynamicStructureFlags> callback) {
        DynamicStructureFlags flags;
        ResourceLocation cached;
        if (Thread.currentThread().getName().contains("worldgen") || !this.configManager.isReady() || !level.hasChunkAt(pos) || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (player != null && player.isCreative() && (cached = this.structureCache.getStructureAtPosition(level, pos)) != null && (flags = this.structureFlags.get(cached)) != null && flags.creativeBypass()) {
            return;
        }
        cached = this.structureCache.getStructureAtPosition(level, pos);
        if (cached != null) {
            flags = this.structureFlags.get(cached);
            if (flags != null) {
                DefeatedStructuresData data = DefeatedStructuresData.get(serverLevel);
                BoundingBox bounds = this.structureCache.getCachedBounds(level, cached, pos);
                if (bounds != null && data.isDefeated(cached, bounds)) {
                    return;
                }
                callback.test(cached, flags);
            }
            return;
        }
        Registry registry = level.registryAccess().registryOrThrow(Registries.STRUCTURE);
        boolean foundStructure = false;
        for (Structure structure : registry) {
            DefeatedStructuresData data;
            StructureStart reference;
            ResourceLocation id = registry.getKey((Object)structure);
            if (id == null || !(reference = serverLevel.structureManager().getStructureAt(pos, structure)).isValid()) continue;
            foundStructure = true;
            id = this.normalizeStructureId(id);
            BoundingBox bounds = reference.getBoundingBox();
            this.structureCache.cacheStructure(level, pos, id, bounds);
            this.structureCache.cacheStructureBounds(level, id, bounds);
            DynamicStructureFlags flags2 = this.structureFlags.get(id);
            if (flags2 == null || (data = DefeatedStructuresData.get(serverLevel)).isDefeated(id, bounds)) break;
            callback.test(id, flags2);
            break;
        }
        if (!foundStructure) {
            EmptyChunksData.get(serverLevel).markEmpty(new ChunkPos(pos));
        }
    }

    @SubscribeEvent
    public void onItemUse(PlayerInteractEvent.RightClickItem event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        Player player = event.getEntity();
        this.handleStructureEvent(player.level(), player.blockPosition(), player, (structure, flags) -> {
            ResourceLocation itemId = event.getLevel().registryAccess().registryOrThrow(Registries.ITEM).getKey((Object)event.getItemStack().getItem());
            if (itemId != null) {
                String itemIdStr = itemId.toString();
                List<String> whitelist = flags.getItemUseWhitelist();
                if (whitelist != null && !whitelist.isEmpty() && whitelist.contains(itemIdStr)) {
                    return false;
                }
                List<String> blacklist = flags.getItemUseBlacklist();
                if (blacklist != null && !blacklist.isEmpty() && blacklist.contains(itemIdStr)) {
                    event.setCanceled(true);
                    player.displayClientMessage((Component)Component.translatable((String)"message.structures_tweaker.item_blacklisted"), true);
                    return true;
                }
            }
            if (!flags.allowEnderPearls() && event.getItemStack().is(Items.ENDER_PEARL)) {
                event.setCanceled(true);
                player.displayClientMessage((Component)Component.translatable((String)"message.structures_tweaker.no_pearls"), true);
                return true;
            }
            if (!flags.allowRiptide() && event.getItemStack().getItem() instanceof TridentItem && player.isInWaterOrRain()) {
                event.setCanceled(true);
                player.displayClientMessage((Component)Component.translatable((String)"message.structures_tweaker.no_riptide"), true);
                return true;
            }
            return false;
        });
    }

    private ResourceLocation normalizeStructureId(ResourceLocation id) {
        String namespace = id.getNamespace();
        String path = id.getPath();
        if (path.startsWith(namespace + "/")) {
            path = path.substring(namespace.length() + 1);
        }
        return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path);
    }

    public static void setInstance(StructureEventHandler handler) {
        INSTANCE = handler;
    }

    public static boolean shouldCancelElytraFlight(Level level, BlockPos pos) {
        if (level.isClientSide() || !(level instanceof ServerLevel) || INSTANCE == null) {
            return false;
        }
        AtomicBoolean shouldCancel = new AtomicBoolean(false);
        INSTANCE.handleStructureEvent(level, pos, (structure, flags) -> {
            if (!flags.allowElytraFlight()) {
                shouldCancel.set(true);
                return true;
            }
            return false;
        });
        return shouldCancel.get();
    }

    @SubscribeEvent
    public void onCreativeFlightToggle(CreativeFlightEvent.Toggle event) {
        if (!this.configManager.isReady()) {
            return;
        }
        if (!(event.getPlayer().level() instanceof ServerLevel)) {
            return;
        }
        if (!event.isEnablingFlight()) {
            return;
        }
        this.handleStructureEvent(event.getPlayer().level(), event.getPlayer().blockPosition(), event.getPlayer(), (structure, flags) -> {
            if (!flags.allowCreativeFlight()) {
                event.getPlayer().displayClientMessage((Component)Component.translatable((String)"message.structures_tweaker.no_creative_flight"), true);
                event.setCanceled(true);
                event.setFlightState(false);
                return true;
            }
            return false;
        });
    }

    @SubscribeEvent
    public void onEnderPearlTeleport(EntityTeleportEvent.EnderPearl event) {
        if (!this.configManager.isReady()) {
            return;
        }
        ServerPlayer player = event.getPlayer();
        if (player == null || player.level().isClientSide()) {
            return;
        }
        BlockPos targetPos = new BlockPos((int)event.getTargetX(), (int)event.getTargetY(), (int)event.getTargetZ());
        this.handleStructureEvent(player.level(), targetPos, (Player)player, (arg_0, arg_1) -> StructureEventHandler.lambda$onEnderPearlTeleport$11(event, (Player)player, arg_0, arg_1));
    }

    @SubscribeEvent
    public void onChorusFruitTeleport(EntityTeleportEvent.ChorusFruit event) {
        if (!this.configManager.isReady()) {
            return;
        }
        LivingEntity livingEntity = event.getEntityLiving();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.level().isClientSide()) {
            return;
        }
        BlockPos targetPos = new BlockPos((int)event.getTargetX(), (int)event.getTargetY(), (int)event.getTargetZ());
        this.handleStructureEvent(player.level(), targetPos, player, (structure, flags) -> {
            if (!flags.allowEnderTeleportation()) {
                event.setCanceled(true);
                player.displayClientMessage((Component)Component.translatable((String)"message.structures_tweaker.no_ender_teleportation"), true);
                return true;
            }
            return false;
        });
    }

    @SubscribeEvent
    public void onPlayerTick(PlayerTickEvent.Post event) {
        if (!this.configManager.isReady()) {
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter % 20 != 0) {
            return;
        }
        Player player = event.getEntity();
        if (player.level().isClientSide() || !player.getAbilities().flying) {
            return;
        }
        if (!(player.level() instanceof ServerLevel)) {
            return;
        }
        this.handleStructureEvent(player.level(), player.blockPosition(), player, (structure, flags) -> {
            if (!flags.allowCreativeFlight()) {
                player.getAbilities().flying = false;
                player.onUpdateAbilities();
                player.displayClientMessage((Component)Component.translatable((String)"message.structures_tweaker.no_creative_flight"), true);
                return true;
            }
            return false;
        });
    }

    @SubscribeEvent
    public void onMobGriefing(EntityMobGriefingEvent event) {
        if (!this.configManager.isReady()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity.level().isClientSide()) {
            return;
        }
        this.handleStructureEvent(entity.level(), entity.blockPosition(), (structure, flags) -> {
            if (flags.preventMobGriefing()) {
                event.setCanGrief(false);
                return true;
            }
            return false;
        });
    }

    private static /* synthetic */ boolean lambda$onEnderPearlTeleport$11(EntityTeleportEvent.EnderPearl event, Player player, ResourceLocation structure, DynamicStructureFlags flags) {
        if (!flags.allowEnderTeleportation()) {
            event.setCanceled(true);
            player.displayClientMessage((Component)Component.translatable((String)"message.structures_tweaker.no_ender_teleportation"), true);
            return true;
        }
        return false;
    }
}

