/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.synesthesia.client;

import java.awt.Color;
import java.lang.ref.WeakReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ActiveSoundEntry {
    private static final long FADE_DURATION_MS = 3000L;
    private final ResourceLocation soundId;
    private final long startTimeMs;
    private final int color;
    private final double x;
    private final double y;
    private final double z;
    @Nullable
    private final WeakReference<Entity> trackedEntity;
    @Nullable
    private final BlockPos trackedBlock;

    public ActiveSoundEntry(ResourceLocation soundId, double x, double y, double z, @Nullable Entity entity, @Nullable BlockPos block) {
        this.soundId = soundId;
        this.startTimeMs = System.currentTimeMillis();
        this.color = ActiveSoundEntry.computeColorFromLocation(soundId);
        this.x = x;
        this.y = y;
        this.z = z;
        this.trackedEntity = entity != null ? new WeakReference<Entity>(entity) : null;
        this.trackedBlock = block;
    }

    public Vec3 getCurrentPosition() {
        Entity entity;
        if (this.trackedEntity != null && (entity = (Entity)this.trackedEntity.get()) != null && entity.isAlive()) {
            return entity.getEyePosition();
        }
        if (this.trackedBlock != null) {
            return Vec3.atCenterOf((Vec3i)this.trackedBlock);
        }
        return new Vec3(this.x, this.y, this.z);
    }

    public float getEntityHeight() {
        Entity entity;
        if (this.trackedEntity != null && (entity = (Entity)this.trackedEntity.get()) != null && entity.isAlive()) {
            return entity.getBbHeight();
        }
        return 0.0f;
    }

    public float getOpacity() {
        long age = System.currentTimeMillis() - this.startTimeMs;
        if (age >= 3000L) {
            return 0.0f;
        }
        return 1.0f - (float)age / 3000.0f;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() - this.startTimeMs >= 3000L;
    }

    public int getColor() {
        return this.color;
    }

    public int getColorWithOpacity() {
        float opacity = this.getOpacity();
        int alpha = (int)(opacity * 255.0f);
        return alpha << 24 | this.color & 0xFFFFFF;
    }

    public String getSoundIdString() {
        return this.soundId.toString();
    }

    public ResourceLocation getSoundId() {
        return this.soundId;
    }

    public boolean hasTrackedEntity() {
        return this.trackedEntity != null && this.trackedEntity.get() != null && ((Entity)this.trackedEntity.get()).isAlive();
    }

    public boolean hasTrackedBlock() {
        return this.trackedBlock != null;
    }

    @Nullable
    public BlockPos getTrackedBlock() {
        return this.trackedBlock;
    }

    public static int computeColorFromLocation(ResourceLocation loc) {
        int hash = loc.toString().hashCode();
        float hue = (float)(hash & 0xFF) / 255.0f;
        float saturation = 0.7f + (float)(hash >> 8 & 0x3F) / 255.0f * 0.3f;
        float brightness = 0.8f + (float)(hash >> 14 & 0x3F) / 255.0f * 0.2f;
        return Color.HSBtoRGB(hue, saturation, brightness);
    }
}

