/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.synesthesia.client;

import com.leclowndu93150.synesthesia.client.ActiveSoundEntry;
import com.leclowndu93150.synesthesia.client.ClientConfig;
import com.leclowndu93150.synesthesia.client.SoundVisualizerData;
import com.leclowndu93150.synesthesia.client.VisualizerState;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;

public class SoundRenderer {
    private static final double LABEL_STACK_THRESHOLD = 1.0;
    private static final float LABEL_OFFSET = 0.3f;

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        if (!VisualizerState.isEnabled()) {
            return;
        }
        SoundVisualizerData.tick();
        List<ActiveSoundEntry> sounds = SoundVisualizerData.getActiveSounds();
        if (sounds.isEmpty()) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        Camera camera = event.getCamera();
        Vec3 cameraPos = camera.getPosition();
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        boolean renderThroughWalls = (Boolean)ClientConfig.RENDER_THROUGH_WALLS.get();
        if (renderThroughWalls) {
            RenderSystem.disableDepthTest();
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        Map<Long, List<ActiveSoundEntry>> groupedSounds = SoundRenderer.groupSoundsByPosition(sounds);
        for (ActiveSoundEntry activeSoundEntry : sounds) {
            SoundRenderer.renderSoundHighlight(poseStack, camera, activeSoundEntry, cameraPos);
        }
        for (Map.Entry entry : groupedSounds.entrySet()) {
            List entries = (List)entry.getValue();
            for (int i = 0; i < entries.size(); ++i) {
                float yOffset = (float)i * 0.3f;
                SoundRenderer.renderSoundLabel(poseStack, (MultiBufferSource)bufferSource, (ActiveSoundEntry)entries.get(i), cameraPos, camera, yOffset);
            }
        }
        bufferSource.endBatch();
        if (renderThroughWalls) {
            RenderSystem.enableDepthTest();
        }
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    }

    private static Map<Long, List<ActiveSoundEntry>> groupSoundsByPosition(List<ActiveSoundEntry> sounds) {
        HashMap<Long, Map> grouped = new HashMap<Long, Map>();
        for (ActiveSoundEntry entry : sounds) {
            Vec3 pos = entry.getCurrentPosition();
            long key = SoundRenderer.packPosition(pos.x, pos.z);
            String soundId = entry.getSoundIdString();
            Map positionGroup = grouped.computeIfAbsent(key, k -> new HashMap());
            if (positionGroup.containsKey(soundId) && !(entry.getOpacity() > ((ActiveSoundEntry)positionGroup.get(soundId)).getOpacity())) continue;
            positionGroup.put(soundId, entry);
        }
        HashMap<Long, List<ActiveSoundEntry>> result = new HashMap<Long, List<ActiveSoundEntry>>();
        for (Map.Entry entry : grouped.entrySet()) {
            ArrayList entries = new ArrayList(((Map)entry.getValue()).values());
            entries.sort((a, b) -> Double.compare(a.getCurrentPosition().y, b.getCurrentPosition().y));
            result.put((Long)entry.getKey(), entries);
        }
        return result;
    }

    private static long packPosition(double x, double z) {
        int ix = (int)Math.floor(x);
        int iz = (int)Math.floor(z);
        return (long)ix << 32 | (long)iz & 0xFFFFFFFFL;
    }

    private static void renderSoundHighlight(PoseStack poseStack, Camera camera, ActiveSoundEntry entry, Vec3 cameraPos) {
        double maxZ;
        double maxY;
        double maxX;
        double minZ;
        double minY;
        double minX;
        Vec3 renderPos;
        Vec3 soundPos = entry.getCurrentPosition();
        float opacity = entry.getOpacity();
        int color = entry.getColor();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        int a = (int)(opacity * 180.0f);
        poseStack.pushPose();
        if (entry.hasTrackedBlock()) {
            BlockPos blockPos = entry.getTrackedBlock();
            renderPos = Vec3.atLowerCornerOf((Vec3i)blockPos).subtract(cameraPos);
            minX = 0.0;
            minY = 0.0;
            minZ = 0.0;
            maxX = 1.0;
            maxY = 1.0;
            maxZ = 1.0;
        } else {
            renderPos = soundPos.subtract(cameraPos);
            double size = entry.hasTrackedEntity() ? 0.4 : 0.25;
            minX = -size;
            minY = -size;
            minZ = -size;
            maxX = size;
            maxY = size;
            maxZ = size;
        }
        poseStack.translate(renderPos.x, renderPos.y, renderPos.z);
        Matrix4f mat = poseStack.last().pose();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder buf = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        int ri = (int)(r * 255.0f);
        int gi = (int)(g * 255.0f);
        int bi = (int)(b * 255.0f);
        buf.addVertex(mat, (float)minX, (float)maxY, (float)minZ).setColor(ri, gi, bi, a);
        buf.addVertex(mat, (float)minX, (float)maxY, (float)maxZ).setColor(ri, gi, bi, a);
        buf.addVertex(mat, (float)maxX, (float)maxY, (float)maxZ).setColor(ri, gi, bi, a);
        buf.addVertex(mat, (float)maxX, (float)maxY, (float)minZ).setColor(ri, gi, bi, a);
        buf.addVertex(mat, (float)minX, (float)maxY, (float)minZ).setColor(ri, gi, bi, a);
        buf.addVertex(mat, (float)maxX, (float)maxY, (float)minZ).setColor(ri, gi, bi, a);
        buf.addVertex(mat, (float)maxX, (float)minY, (float)minZ).setColor(ri, gi, bi, a);
        buf.addVertex(mat, (float)minX, (float)minY, (float)minZ).setColor(ri, gi, bi, a);
        buf.addVertex(mat, (float)maxX, (float)maxY, (float)maxZ).setColor(ri, gi, bi, a);
        buf.addVertex(mat, (float)minX, (float)maxY, (float)maxZ).setColor(ri, gi, bi, a);
        buf.addVertex(mat, (float)minX, (float)minY, (float)maxZ).setColor(ri, gi, bi, a);
        buf.addVertex(mat, (float)maxX, (float)minY, (float)maxZ).setColor(ri, gi, bi, a);
        buf.addVertex(mat, (float)minX, (float)maxY, (float)maxZ).setColor(ri, gi, bi, a);
        buf.addVertex(mat, (float)minX, (float)maxY, (float)minZ).setColor(ri, gi, bi, a);
        buf.addVertex(mat, (float)minX, (float)minY, (float)minZ).setColor(ri, gi, bi, a);
        buf.addVertex(mat, (float)minX, (float)minY, (float)maxZ).setColor(ri, gi, bi, a);
        buf.addVertex(mat, (float)maxX, (float)minY, (float)maxZ).setColor(ri, gi, bi, a);
        buf.addVertex(mat, (float)maxX, (float)minY, (float)minZ).setColor(ri, gi, bi, a);
        buf.addVertex(mat, (float)maxX, (float)maxY, (float)minZ).setColor(ri, gi, bi, a);
        buf.addVertex(mat, (float)maxX, (float)maxY, (float)maxZ).setColor(ri, gi, bi, a);
        buf.addVertex(mat, (float)maxX, (float)minY, (float)minZ).setColor(ri, gi, bi, a);
        buf.addVertex(mat, (float)maxX, (float)minY, (float)maxZ).setColor(ri, gi, bi, a);
        buf.addVertex(mat, (float)minX, (float)minY, (float)maxZ).setColor(ri, gi, bi, a);
        buf.addVertex(mat, (float)minX, (float)minY, (float)minZ).setColor(ri, gi, bi, a);
        BufferUploader.drawWithShader((MeshData)buf.buildOrThrow());
        poseStack.popPose();
    }

    private static void renderSoundLabel(PoseStack poseStack, MultiBufferSource bufferSource, ActiveSoundEntry entry, Vec3 cameraPos, Camera camera, float yOffset) {
        Vec3 soundPos = entry.getCurrentPosition();
        float opacity = entry.getOpacity();
        String labelText = entry.getSoundIdString();
        Font font = Minecraft.getInstance().font;
        poseStack.pushPose();
        double labelY = soundPos.y + (entry.hasTrackedBlock() ? 1.5 : 0.6) + (double)yOffset;
        Vec3 labelPos = new Vec3(soundPos.x, labelY, soundPos.z).subtract(cameraPos);
        poseStack.translate(labelPos.x, labelPos.y, labelPos.z);
        poseStack.mulPose(camera.rotation());
        poseStack.scale(0.025f, -0.025f, 0.025f);
        int alpha = (int)(opacity * 255.0f);
        int textColor = alpha << 24 | 0xFFFFFF;
        float textWidth = font.width(labelText);
        font.drawInBatch(labelText, -textWidth / 2.0f, 0.0f, textColor, false, poseStack.last().pose(), bufferSource, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
        poseStack.popPose();
    }
}

