/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.tempad.client.widgets;

import earth.terrarium.olympus.client.components.base.BaseWidget;
import earth.terrarium.tempad.Tempad;
import earth.terrarium.tempad.client.TempadClientKt;
import earth.terrarium.tempad.client.TempadUI;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0006\u0010\u001c\u001a\u00020\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Learth/terrarium/tempad/client/widgets/CraftingRecipeWidget;", "Learth/terrarium/olympus/client/components/base/BaseWidget;", "recipe", "Lnet/minecraft/world/item/crafting/CraftingRecipe;", "<init>", "(Lnet/minecraft/world/item/crafting/CraftingRecipe;)V", "getRecipe", "()Lnet/minecraft/world/item/crafting/CraftingRecipe;", "font", "Lnet/minecraft/client/gui/Font;", "kotlin.jvm.PlatformType", "getFont", "()Lnet/minecraft/client/gui/Font;", "Lnet/minecraft/client/gui/Font;", "age", "", "getAge", "()I", "setAge", "(I)V", "renderWidget", "", "graphics", "Lnet/minecraft/client/gui/GuiGraphics;", "mouseX", "mouseY", "partialTick", "", "tick", "Companion", "tempad-1.21.1"})
public final class CraftingRecipeWidget
extends BaseWidget {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CraftingRecipe recipe;
    private final Font font;
    private int age;

    public CraftingRecipeWidget(@NotNull CraftingRecipe recipe2) {
        Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
        this.recipe = recipe2;
        this.font = Minecraft.getInstance().font;
        this.height = 58;
        this.width = 90;
    }

    @NotNull
    public final CraftingRecipe getRecipe() {
        return this.recipe;
    }

    public final Font getFont() {
        return this.font;
    }

    public final int getAge() {
        return this.age;
    }

    public final void setAge(int n) {
        this.age = n;
    }

    protected void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        graphics.blitSprite(TempadUI.INSTANCE.getElement().get(true, false), this.getX(), this.getY(), 58, this.height);
        int tableSize = this.recipe.getIngredients().size() > 4 ? 3 : 2;
        boolean tooltipChanged = false;
        for (int row = 0; row < tableSize; ++row) {
            for (int col = 0; col < tableSize && row * tableSize + col < this.recipe.getIngredients().size(); ++col) {
                Object object = this.recipe.getIngredients().get(row * tableSize + col);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                Ingredient ingredient = (Ingredient)object;
                if (ingredient.getItems().length == 0) continue;
                ItemStack stack = ingredient.getItems()[this.age / 30 % ingredient.getItems().length];
                int itemX = this.getX() + 3 + col * 18;
                int itemY = this.getY() + 3 + row * 18;
                graphics.renderItem(stack, itemX, itemY);
                if (mouseX <= itemX - 1 || mouseX >= itemX + 17 || mouseY <= itemY - 1 || mouseY >= itemY + 17) continue;
                tooltipChanged = true;
                this.setTooltip(Tooltip.create((Component)stack.getHoverName()));
            }
        }
        graphics.fill(this.getX() + 58, this.getY() + 25, this.getX() + this.width - 20, this.getY() + 32, Tempad.Companion.getORANGE().getValue());
        graphics.blitSprite(TempadUI.INSTANCE.getElement().get(true, false), this.getX() + this.width - 20, this.getY() + 18, 20, 20);
        Level level = TempadClientKt.getClientLevel();
        Intrinsics.checkNotNull((Object)level);
        ItemStack resultItem = this.recipe.getResultItem((HolderLookup.Provider)level.registryAccess());
        graphics.renderItem(resultItem, this.getX() + this.width - 18, this.getY() + 20);
        graphics.renderItemDecorations(this.font, resultItem, this.getX() + this.width - 18, this.getY() + 20);
        if (mouseX > this.getX() + this.width - 18 && mouseX < this.getX() + this.width && mouseY > this.getY() + 20 && mouseY < this.getY() + 38) {
            this.setTooltip(Tooltip.create((Component)resultItem.getHoverName()));
        } else if (!tooltipChanged) {
            this.setTooltip(null);
        }
    }

    public final void tick() {
        int n = this.age;
        this.age = n + 1;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Learth/terrarium/tempad/client/widgets/CraftingRecipeWidget$Companion;", "", "<init>", "()V", "create", "Learth/terrarium/tempad/client/widgets/CraftingRecipeWidget;", "id", "Lnet/minecraft/resources/ResourceLocation;", "tempad-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final CraftingRecipeWidget create(@NotNull ResourceLocation id) {
            CraftingRecipe craftingRecipe;
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Object object = TempadClientKt.getClientLevel();
            if (object == null || (object = object.getRecipeManager()) == null || (object = object.byKey(id)) == null) {
                return null;
            }
            Object recipe2 = object;
            RecipeHolder recipeHolder = (RecipeHolder)OptionalsKt.getOrNull((Optional)recipe2);
            Recipe recipe3 = recipeHolder != null ? recipeHolder.value() : null;
            CraftingRecipe craftingRecipe2 = craftingRecipe = recipe3 instanceof CraftingRecipe ? (CraftingRecipe)recipe3 : null;
            if (craftingRecipe != null) {
                CraftingRecipe craftingRecipe3 = craftingRecipe;
                boolean bl = false;
                return new CraftingRecipeWidget(craftingRecipe3);
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

