/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.packets;

import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.core.network.PacketContext;
import com.supermartijn642.core.util.Pair;
import com.supermartijn642.tesseract.manager.TesseractReference;
import com.supermartijn642.tesseract.manager.TesseractTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;

public class PacketRemoveTesseractReferences
implements BasePacket {
    private Collection<Pair<String, BlockPos>> references;

    public PacketRemoveTesseractReferences(Collection<TesseractReference> references) {
        this.references = references.stream().map(reference -> Pair.of((Object)reference.getDimension(), (Object)reference.getPos())).collect(Collectors.toSet());
    }

    public PacketRemoveTesseractReferences() {
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.references.size());
        for (Pair<String, BlockPos> reference : this.references) {
            buffer.writeUtf((String)reference.left());
            buffer.writeBlockPos((BlockPos)reference.right());
        }
    }

    public void read(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        this.references = new ArrayList<Pair<String, BlockPos>>(size);
        for (int i = 0; i < size; ++i) {
            this.references.add((Pair<String, BlockPos>)Pair.of((Object)buffer.readUtf(), (Object)buffer.readBlockPos()));
        }
    }

    public void handle(PacketContext context) {
        if (context.getHandlingSide().isServer()) {
            return;
        }
        for (Pair<String, BlockPos> reference : this.references) {
            TesseractTracker.CLIENT.remove((String)reference.left(), (BlockPos)reference.right());
        }
    }
}

