/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tipsmod.common.impl.client.tips.conditions;

import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.darkhax.tipsmod.common.api.TipsAPI;
import net.darkhax.tipsmod.common.impl.TipsMod;
import net.darkhax.tipsmod.common.impl.client.tips.conditions.IRuleBuilder;
import net.darkhax.tipsmod.common.impl.client.tips.conditions.VanillaScreenIds;
import net.darkhax.tipsmod.common.impl.resources.Helpers;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.DimensionType;

public class RuleBuilders {
    public static final IRuleBuilder<Screen> SCREEN = rule -> {
        if (rule.equalsIgnoreCase("tipsmod:built-in")) {
            return TipsAPI::isDefaultScreen;
        }
        if (Helpers.isValid(rule)) {
            ResourceLocation targetScreen = ResourceLocation.tryParse((String)rule);
            if (targetScreen != null && "minecraft".equalsIgnoreCase(targetScreen.getNamespace())) {
                return screen -> VanillaScreenIds.is(targetScreen, screen.getClass());
            }
        } else {
            if (rule.contains(".")) {
                return screen -> rule.equalsIgnoreCase(screen.getClass().getCanonicalName());
            }
            return screen -> rule.equals(screen.getClass().getSimpleName());
        }
        TipsMod.LOG.error("Screen condition with ID {} is not valid. Only the vanilla screens have IDs.", (Object)rule);
        return screen -> false;
    };
    public static final IRuleBuilder<ResourceLocation> RESOURCE_LOCATION = rule -> {
        if (Helpers.isValid(rule)) {
            ResourceLocation targetEntryID = ResourceLocation.tryParse((String)rule);
            return targetEntryID == null ? entry -> false : entry -> entry.equals((Object)targetEntryID);
        }
        if (Helpers.isNamespace(rule)) {
            return entry -> rule.equalsIgnoreCase(entry.getNamespace());
        }
        if (rule.startsWith("~")) {
            try {
                Pattern pattern = Pattern.compile(rule);
                return entry -> pattern.matcher(entry.toString()).matches();
            }
            catch (PatternSyntaxException e) {
                TipsMod.LOG.error("An invalid Regex pattern was used! Rule '{}' is invalid!", (Object)rule, (Object)e);
                return entry -> false;
            }
        }
        TipsMod.LOG.error("An invalid pattern was used. Pattern must be a valid resource location, namespace, or regex pattern. '{}'", (Object)rule);
        return entry -> false;
    };
    public static final IRuleBuilder<Set<ResourceLocation>> RESOURCE_LOCATION_SET = rule -> {
        Predicate<ResourceLocation> rlRule = RESOURCE_LOCATION.build(rule);
        return set -> set.stream().anyMatch(rlRule);
    };
    public static final IRuleBuilder<Holder<Biome>> BIOME = rule -> RuleBuilders.buildRegistryRule(Registries.BIOME, rule);
    public static final IRuleBuilder<Holder<DimensionType>> DIMENSION = rule -> RuleBuilders.buildRegistryRule(Registries.DIMENSION_TYPE, rule);

    private static <T> Predicate<Holder<T>> buildRegistryRule(ResourceKey<? extends Registry<T>> regKey, String rule) {
        if (Helpers.isValid(rule)) {
            ResourceLocation targetEntryID = ResourceLocation.tryParse((String)rule);
            return targetEntryID == null ? entry -> false : entry -> entry.is(targetEntryID);
        }
        if (Helpers.isNamespace(rule)) {
            return entry -> entry.unwrapKey().map(id -> rule.equalsIgnoreCase(id.location().getNamespace())).orElse(false);
        }
        if (rule.startsWith("#") && Helpers.isValid(rule.substring(1))) {
            TagKey tag = TagKey.create(regKey, (ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)rule.substring(1))));
            return entry -> entry.is(tag);
        }
        if (rule.startsWith("~")) {
            try {
                Pattern pattern = Pattern.compile(rule);
                return entry -> entry.unwrapKey().map(key -> pattern.matcher(key.toString()).matches()).orElse(false);
            }
            catch (PatternSyntaxException e) {
                TipsMod.LOG.error("An invalid Regex pattern was used! Rule '{}' is invalid!", (Object)rule, (Object)e);
                return entry -> false;
            }
        }
        TipsMod.LOG.error("An invalid pattern was used. Pattern must be a valid resource location, namespace, tag, or regex pattern. '{}'", (Object)rule);
        return entry -> false;
    }
}

