/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium;

import com.hrznstudio.titanium.block.BasicBlock;
import com.hrznstudio.titanium.client.screen.container.BasicAddonScreen;
import com.hrznstudio.titanium.container.BasicAddonContainer;
import com.hrznstudio.titanium.util.RayTraceUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;

@Mod(value="titanium", dist={Dist.CLIENT})
public class TitaniumClient {
    public static void registerModelLoader() {
    }

    public TitaniumClient(IEventBus bus) {
        bus.addListener(event -> event.register((MenuType)BasicAddonContainer.TYPE.get(), BasicAddonScreen::new));
    }

    public static EntityRenderer<? super AbstractClientPlayer> getPlayerRenderer(Minecraft minecraft, AbstractClientPlayer player) {
        return minecraft.getEntityRenderDispatcher().getRenderer((Entity)player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void blockOverlayEvent(RenderHighlightEvent.Block event) {
        BlockHitResult traceResult = event.getTarget();
        BlockState og = Minecraft.getInstance().level.getBlockState(traceResult.getBlockPos());
        if (og.getBlock() instanceof BasicBlock && ((BasicBlock)og.getBlock()).hasIndividualRenderVoxelShape()) {
            VoxelShape shape = RayTraceUtils.rayTraceVoxelShape(traceResult, (Level)Minecraft.getInstance().level, (LivingEntity)Minecraft.getInstance().player, 32.0, event.getDeltaTracker().getGameTimeDeltaPartialTick(false));
            BlockPos blockpos = event.getTarget().getBlockPos();
            event.setCanceled(true);
            if (shape != null && !shape.isEmpty()) {
                PoseStack stack = new PoseStack();
                stack.pushPose();
                Camera info = event.getCamera();
                double d0 = info.getPosition().x();
                double d1 = info.getPosition().y();
                double d2 = info.getPosition().z();
                VertexConsumer builder = event.getMultiBufferSource().getBuffer((RenderType)RenderType.LINES);
                LevelRenderer.renderShape((PoseStack)stack, (VertexConsumer)builder, (VoxelShape)shape, (double)((double)blockpos.getX() - d0), (double)((double)blockpos.getY() - d1), (double)((double)blockpos.getZ() - d2), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
                stack.popPose();
            }
        }
    }
}

