/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.block_network;

import com.hrznstudio.titanium.block_network.Network;
import com.hrznstudio.titanium.block_network.NetworkFactory;
import com.hrznstudio.titanium.block_network.NetworkRegistry;
import com.hrznstudio.titanium.block_network.element.NetworkElement;
import com.hrznstudio.titanium.block_network.element.NetworkElementFactory;
import com.hrznstudio.titanium.block_network.element.NetworkElementRegistry;
import com.hrznstudio.titanium.block_network.graph.NetworkGraphScannerResult;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkManager
extends SavedData {
    private static final String NAME = "titanium_networks";
    private static final Logger LOGGER = LogManager.getLogger(NetworkManager.class);
    private final Level level;
    private final Map<String, Network> networks = new HashMap<String, Network>();
    private final Map<BlockPos, NetworkElement> elements = new HashMap<BlockPos, NetworkElement>();

    public NetworkManager(Level level) {
        this.level = level;
    }

    public static NetworkManager get(Level level) {
        return NetworkManager.get((ServerLevel)level);
    }

    public static NetworkManager get(ServerLevel level) {
        return (NetworkManager)level.getDataStorage().computeIfAbsent(new SavedData.Factory(() -> new NetworkManager((Level)level), (tag, provider) -> {
            NetworkManager networkManager = new NetworkManager((Level)level);
            networkManager.load((CompoundTag)tag);
            return networkManager;
        }), NAME);
    }

    public void addNetwork(Network network) {
        if (this.networks.containsKey(network.getId())) {
            throw new RuntimeException("Duplicate network " + network.getId());
        }
        this.networks.put(network.getId(), network);
        LOGGER.debug("Network {} created", (Object)network.getId());
        this.setDirty();
    }

    public void removeNetwork(String id) {
        if (!this.networks.containsKey(id)) {
            throw new RuntimeException("Network " + id + " not found");
        }
        this.networks.remove(id);
        LOGGER.debug("Network {} removed", (Object)id);
        this.setDirty();
    }

    private void formNetworkAt(Level level, BlockPos pos, ResourceLocation type) {
        Network network = NetworkRegistry.INSTANCE.getFactory(type).create(pos);
        this.addNetwork(network);
        network.scanGraph(level, pos);
    }

    private void mergeNetworksIntoOne(Set<NetworkElement> candidates, Level level, BlockPos pos) {
        if (candidates.isEmpty()) {
            throw new RuntimeException("Cannot merge networks: no candidates");
        }
        HashSet<Network> networkCandidates = new HashSet<Network>();
        for (NetworkElement candidate : candidates) {
            if (candidate.getNetwork() == null) {
                throw new RuntimeException("Element network is null!");
            }
            networkCandidates.add(candidate.getNetwork());
        }
        Iterator networks = networkCandidates.iterator();
        Network mainNetwork = (Network)networks.next();
        HashSet<Network> mergedNetworks = new HashSet<Network>();
        while (networks.hasNext()) {
            Network otherNetwork = (Network)networks.next();
            boolean canMerge = mainNetwork.getType().equals((Object)otherNetwork.getType());
            if (!canMerge) continue;
            mergedNetworks.add(otherNetwork);
            this.removeNetwork(otherNetwork.getId());
        }
        mainNetwork.scanGraph(level, pos);
        mergedNetworks.forEach(n -> n.onMergedWith(mainNetwork));
    }

    public void addElement(NetworkElement networkElement) {
        if (this.elements.containsKey(networkElement.getPos())) {
            throw new RuntimeException("Network element at " + String.valueOf(networkElement.getPos()) + " already exists");
        }
        this.elements.put(networkElement.getPos(), networkElement);
        LOGGER.debug("Network element added at {}", (Object)networkElement.getPos());
        this.setDirty();
        Set<NetworkElement> adjacentElement = this.findAdjacentElements(networkElement, networkElement.getNetworkType());
        if (adjacentElement.isEmpty()) {
            this.formNetworkAt(networkElement.getLevel(), networkElement.getPos(), networkElement.getNetworkType());
        } else {
            this.mergeNetworksIntoOne(adjacentElement, networkElement.getLevel(), networkElement.getPos());
        }
    }

    public void removeElement(BlockPos pos) {
        NetworkElement element = this.getElement(pos);
        if (element == null) {
            throw new RuntimeException("Element at " + String.valueOf(pos) + " was not found");
        }
        if (element.getNetwork() == null) {
            LOGGER.warn("Removed element at {} has no associated network", (Object)element.getPos());
        }
        this.elements.remove(element.getPos());
        LOGGER.debug("Element removed at {}", (Object)element.getPos());
        this.setDirty();
        if (element.getNetwork() != null) {
            this.splitNetworks(element);
        }
    }

    private void splitNetworks(NetworkElement originElement) {
        for (NetworkElement adjacent : this.findAdjacentElements(originElement, originElement.getNetworkType())) {
            if (adjacent.getNetwork() == null) {
                throw new RuntimeException("Adjacent element has no network");
            }
            if (adjacent.getNetwork() == originElement.getNetwork()) continue;
        }
        NetworkElement otherElementInNetwork = this.findFirstAdjacentElement(originElement, originElement.getNetworkType());
        if (otherElementInNetwork != null) {
            otherElementInNetwork.getNetwork().setOriginPos(otherElementInNetwork.getPos());
            this.setDirty();
            NetworkGraphScannerResult result = otherElementInNetwork.getNetwork().scanGraph(otherElementInNetwork.getLevel(), otherElementInNetwork.getPos());
            boolean foundRemovedElement = false;
            for (NetworkElement removed : result.getRemovedElements()) {
                if (removed.getPos().equals((Object)originElement.getPos())) {
                    foundRemovedElement = true;
                    continue;
                }
                if (removed.getNetwork() != null) continue;
                this.formNetworkAt(removed.getLevel(), removed.getPos(), removed.getNetworkType());
            }
            if (!foundRemovedElement) {
                throw new RuntimeException("Didn't find removed element when splitting network");
            }
        } else {
            LOGGER.debug("Removing empty network {}", (Object)originElement.getNetwork().getId());
            this.removeNetwork(originElement.getNetwork().getId());
        }
    }

    private Set<NetworkElement> findAdjacentElements(NetworkElement current, ResourceLocation networkType) {
        HashSet<NetworkElement> elements = new HashSet<NetworkElement>();
        for (Direction dir : Direction.values()) {
            NetworkElement element = this.getElement(current.getPos().relative(dir));
            if (!current.canConnectFrom(dir) || element == null || !element.getNetworkType().equals((Object)networkType) || !element.canConnectFrom(dir.getOpposite())) continue;
            elements.add(element);
        }
        return elements;
    }

    @Nullable
    private NetworkElement findFirstAdjacentElement(NetworkElement current, ResourceLocation networkType) {
        for (Direction dir : Direction.values()) {
            NetworkElement element;
            if (!current.canConnectFrom(dir) || (element = this.getElement(current.getPos().relative(dir))) == null || !element.getNetworkType().equals((Object)networkType) || !element.canConnectFrom(dir.getOpposite()) || current.getNetwork() != element.getNetwork()) continue;
            return element;
        }
        return null;
    }

    @Nullable
    public NetworkElement getElement(BlockPos pos) {
        return this.elements.get(pos);
    }

    public Collection<Network> getNetworks() {
        return this.networks.values();
    }

    public void load(CompoundTag tag) {
        ListTag elements = tag.getList("elements", 10);
        for (Tag elementTag : elements) {
            CompoundTag elementTagCompound = (CompoundTag)elementTag;
            ResourceLocation factoryId = ResourceLocation.parse((String)elementTagCompound.getString("id"));
            NetworkElementFactory factory = NetworkElementRegistry.INSTANCE.getFactory(factoryId);
            if (factory == null) {
                LOGGER.warn("Element {} no longer exists", (Object)factoryId.toString());
                continue;
            }
            NetworkElement element = factory.createFromNbt(this.level, elementTagCompound);
            this.elements.put(element.getPos(), element);
        }
        ListTag nets = tag.getList("networks", 10);
        for (Tag netTag : nets) {
            CompoundTag netTagCompound = (CompoundTag)netTag;
            if (!netTagCompound.contains("type")) {
                LOGGER.warn("Skipping network without type");
                continue;
            }
            ResourceLocation type = ResourceLocation.parse((String)netTagCompound.getString("type"));
            NetworkFactory factory = NetworkRegistry.INSTANCE.getFactory(type);
            if (factory == null) {
                LOGGER.warn("Unknown network type {}", (Object)type.toString());
                continue;
            }
            Network network = factory.create(netTagCompound);
            this.networks.put(network.getId(), network);
        }
        LOGGER.debug("Read {} elements", (Object)elements.size());
        LOGGER.debug("Read {} networks", (Object)this.networks.size());
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        ListTag elements = new ListTag();
        this.elements.values().forEach(p -> {
            CompoundTag elementTag = new CompoundTag();
            elementTag.putString("id", p.getId().toString());
            elements.add((Object)p.writeToNbt(elementTag));
        });
        tag.put("elements", (Tag)elements);
        ListTag networks = new ListTag();
        this.networks.values().forEach(n -> {
            CompoundTag networkTag = new CompoundTag();
            networkTag.putString("type", n.getType().toString());
            networks.add((Object)n.writeToNbt(networkTag));
        });
        tag.put("networks", (Tag)networks);
        return tag;
    }

    public Map<BlockPos, NetworkElement> getElements() {
        return this.elements;
    }
}

