/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.frame;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.xylonity.tooltipoverhaul.TooltipOverhaul;
import dev.xylonity.tooltipoverhaul.client.frame.CustomFrameData;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;

public class CustomFrameDataDeserializer
implements JsonDeserializer<CustomFrameData> {
    public CustomFrameData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
        if (!json.isJsonObject()) {
            throw new JsonParseException("Failed loading custom_frames JSON, invalid object for CustomFrameData");
        }
        JsonObject entry = json.getAsJsonObject();
        List<String> items = this.parseStringList(entry, "items");
        List<String> tags = this.parseStringList(entry, "tags");
        Optional<String> namespace = this.parseString(entry, "namespace");
        Optional<String> texture = this.parseString(entry, "texture");
        Optional<Integer> backgroundColor = this.parseInt(entry, "backgroundColor");
        Optional<String> borderType = this.parseString(entry, "borderType");
        Optional<CustomFrameData.GradientType> gradientType = this.parseEnum(entry, "gradientType", CustomFrameData.GradientType.class);
        Optional<List<String>> gradientColors = this.parseOptionalStringList(entry, "gradientColors");
        Optional<String> itemRating = this.parseString(entry, "itemRating");
        Optional<String> colorItemRating = this.parseString(entry, "colorItemRating");
        Optional<String> ratingAlignment = this.parseString(entry, "ratingAlignment");
        Optional<String> titleAlignment = this.parseString(entry, "titleAlignment");
        Optional<Integer> tooltipPositionX = this.parseInt(entry, "tooltipPositionX");
        Optional<Integer> tooltipPositionY = this.parseInt(entry, "tooltipPositionY");
        Optional<Integer> mainPanelPaddingX = this.parseInt(entry, "mainPanelPaddingX");
        Optional<Integer> mainPanelPaddingY = this.parseInt(entry, "mainPanelPaddingY");
        Optional<Integer> dividerLineTopPadding = this.parseInt(entry, "dividerLineTopPadding");
        Optional<Integer> dividerLineBottomPadding = this.parseInt(entry, "dividerLineBottomPadding");
        Optional<Float> iconSize = this.parseFloat(entry, "iconSize");
        Optional<Float> iconRotatingSpeed = this.parseFloat(entry, "iconRotatingSpeed");
        Optional<String> iconAppearAnimation = this.parseString(entry, "iconAppearAnimation");
        Optional<Integer> secondPanelX = this.parseInt(entry, "secondPanelX");
        Optional<Integer> secondPanelY = this.parseInt(entry, "secondPanelY");
        Optional<Integer> secondPanelSizeX = this.parseInt(entry, "secondPanelSizeX");
        Optional<Integer> secondPanelSizeY = this.parseInt(entry, "secondPanelSizeY");
        Optional<Float> secondPanelRendererSpeed = this.parseFloat(entry, "secondPanelRendererSpeed");
        Optional<String> dividerLineType = this.parseString(entry, "dividerLineType");
        Optional<String> dividerLineColor = this.parseString(entry, "dividerLineColor");
        Optional<String> particles = this.parseString(entry, "particles");
        Optional<String> specialEffect = this.parseString(entry, "specialEffect");
        List<String> vignettes = this.parseStringList(entry, "vignettes");
        Optional<String> iconBackgroundType = this.parseString(entry, "iconBackgroundType");
        Optional<Boolean> showSecondPanel = this.parseBool(entry, "showSecondPanel");
        Optional<Boolean> showRating = this.parseBool(entry, "showRating");
        Optional<Boolean> showShadow = this.parseBool(entry, "showShadow");
        Optional<Boolean> usePlayerSkinInPreview = this.parseBool(entry, "usePlayerSkinInPreview");
        Optional<String> previewPanelModel = this.parseString(entry, "previewPanelModel");
        Optional<Boolean> disableIcon = this.parseBool(entry, "disableIcon");
        Optional<Boolean> disableScrolling = this.parseBool(entry, "disableScrolling");
        Optional<Boolean> disableTooltip = this.parseBool(entry, "disableTooltip");
        Optional<Boolean> disableDividerLine = this.parseBool(entry, "disableDividerLine");
        return new CustomFrameData(items, tags, namespace, texture, backgroundColor, borderType, gradientType, gradientColors, itemRating, colorItemRating, ratingAlignment, titleAlignment, tooltipPositionX, tooltipPositionY, mainPanelPaddingX, mainPanelPaddingY, dividerLineTopPadding, dividerLineBottomPadding, iconSize, iconRotatingSpeed, iconAppearAnimation, secondPanelX, secondPanelY, secondPanelSizeX, secondPanelSizeY, secondPanelRendererSpeed, dividerLineType, dividerLineColor, particles, specialEffect, vignettes, iconBackgroundType, usePlayerSkinInPreview, previewPanelModel, showSecondPanel, showRating, showShadow, disableIcon, disableScrolling, disableTooltip, disableDividerLine);
    }

    private List<String> parseStringList(JsonObject content, String field) {
        if (!content.has(field)) {
            return List.of();
        }
        JsonElement ele = content.get(field);
        if (ele.isJsonArray()) {
            return ele.getAsJsonArray().asList().stream().filter(JsonElement::isJsonPrimitive).map(JsonElement::getAsString).toList();
        }
        return List.of();
    }

    private Optional<Boolean> parseBool(JsonObject content, String field) {
        if (!content.has(field) || content.get(field).isJsonNull()) {
            return Optional.empty();
        }
        JsonElement elem = content.get(field);
        if (elem.isJsonPrimitive()) {
            if (elem.getAsJsonPrimitive().isBoolean()) {
                return Optional.of(elem.getAsBoolean());
            }
            String s = elem.getAsString().trim().toLowerCase();
            if ("true".equals(s)) {
                return Optional.of(true);
            }
            if ("false".equals(s)) {
                return Optional.of(false);
            }
        }
        return Optional.empty();
    }

    private Optional<String> parseString(JsonObject content, String field) {
        if (!content.has(field) || content.get(field).isJsonNull()) {
            return Optional.empty();
        }
        JsonElement elem = content.get(field);
        if (elem.isJsonPrimitive()) {
            String value = elem.getAsString();
            return value.trim().isEmpty() ? Optional.empty() : Optional.of(value);
        }
        return Optional.empty();
    }

    private Optional<List<String>> parseOptionalStringList(JsonObject content, String field) {
        if (!content.has(field) || content.get(field).isJsonNull()) {
            return Optional.empty();
        }
        JsonElement elem = content.get(field);
        if (elem.isJsonArray()) {
            List<String> list = elem.getAsJsonArray().asList().stream().filter(JsonElement::isJsonPrimitive).map(JsonElement::getAsString).toList();
            return list.isEmpty() ? Optional.empty() : Optional.of(list);
        }
        return Optional.empty();
    }

    private Optional<Integer> parseInt(JsonObject content, String field) {
        if (!content.has(field) || content.get(field).isJsonNull()) {
            return Optional.empty();
        }
        JsonElement elem = content.get(field);
        if (elem.isJsonPrimitive() && elem.getAsJsonPrimitive().isNumber()) {
            return Optional.of(elem.getAsInt());
        }
        return Optional.empty();
    }

    private Optional<Float> parseFloat(JsonObject content, String field) {
        if (!content.has(field) || content.get(field).isJsonNull()) {
            return Optional.empty();
        }
        JsonElement elem = content.get(field);
        if (elem.isJsonPrimitive() && elem.getAsJsonPrimitive().isNumber()) {
            return Optional.of(Float.valueOf(elem.getAsFloat()));
        }
        return Optional.empty();
    }

    private <T extends Enum<T>> Optional<T> parseEnum(JsonObject content, String field, Class<T> enumClass) {
        if (!content.has(field) || content.get(field).isJsonNull()) {
            return Optional.empty();
        }
        JsonElement elem = content.get(field);
        if (elem.isJsonPrimitive()) {
            try {
                return Optional.of(Enum.valueOf(enumClass, elem.getAsString().toUpperCase().replace('-', '_')));
            }
            catch (Exception e) {
                TooltipOverhaul.LOGGER.warn("Invalid enum value for {}: {}", (Object)field, (Object)elem.getAsString());
                return Optional.empty();
            }
        }
        return Optional.empty();
    }
}

