/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.frame;

import dev.xylonity.tooltipoverhaul.TooltipOverhaul;
import dev.xylonity.tooltipoverhaul.client.frame.CustomFrameData;
import dev.xylonity.tooltipoverhaul.client.frame.CustomFrameLoader;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.ItemStack;

public class CustomFrameManager {
    private static final Map<ResourceLocation, CustomFrameData> customFrames = new ConcurrentHashMap<ResourceLocation, CustomFrameData>();
    private static boolean INIT = false;

    public static void initialize() {
        if (INIT) {
            return;
        }
        try {
            customFrames.clear();
            customFrames.putAll(CustomFrameLoader.loadCustomFrames(Minecraft.getInstance().getResourceManager(), TooltipOverhaul.PLATFORM.getConfigPath()));
            INIT = true;
            TooltipOverhaul.LOGGER.info("{} frames have been loaded!", (Object)customFrames.size());
        }
        catch (Exception e) {
            TooltipOverhaul.LOGGER.error("Failed to initialize custom frames loader: {}", (Object)e.getMessage());
        }
    }

    public static void initialize(ResourceManager resourceManager) {
        if (INIT) {
            return;
        }
        try {
            customFrames.clear();
            customFrames.putAll(CustomFrameLoader.loadCustomFrames(resourceManager, TooltipOverhaul.PLATFORM.getConfigPath()));
            INIT = true;
            TooltipOverhaul.LOGGER.info("{} frames have been loaded!", (Object)customFrames.size());
        }
        catch (Exception e) {
            TooltipOverhaul.LOGGER.error("Failed to initialize custom frames loader: {}", (Object)e.getMessage());
        }
    }

    public static void reset() {
        customFrames.clear();
        INIT = false;
    }

    public static Optional<CustomFrameData> of(ItemStack stack) {
        if (!INIT) {
            CustomFrameManager.initialize();
        }
        return customFrames.values().stream().filter(cfg -> cfg.matches(stack)).findFirst();
    }
}

