/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.layout;

import dev.xylonity.tooltipoverhaul.client.render.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.util.PositionUtils;
import dev.xylonity.tooltipoverhaul.client.util.TextAxis;
import net.minecraft.world.phys.Vec2;

public class TooltipPositionCalculator {
    private final TooltipContext context;

    public TooltipPositionCalculator(TooltipContext context) {
        this.context = context;
    }

    public Vec2 calculate() {
        boolean isMainTooltip = this.context.isMainTooltip();
        int paddingX = this.context.getPaddingX();
        int paddingY = this.context.getPaddingY();
        int mouseX = this.context.getMouseX();
        int mouseY = this.context.getMouseY();
        int tooltipWidth = (int)this.context.getTooltipSize().x;
        int tooltipHeight = (int)this.context.getTooltipSize().y;
        int screenWidth = this.context.getScreenWidth();
        int screenHeight = this.context.getScreenHeight();
        float posX = mouseX + (isMainTooltip ? 12 : -12) + PositionUtils.getMainPanelPosition(this.context, TextAxis.X);
        float posY = mouseY - 12 + PositionUtils.getMainPanelPosition(this.context, TextAxis.Y);
        if (isMainTooltip) {
            boolean hasEquippedContext;
            TooltipContext equippedContext = this.context.getOtherTooltipContext();
            boolean bl = hasEquippedContext = equippedContext != null;
            if (!hasEquippedContext && posX + (float)tooltipWidth > (float)screenWidth) {
                posX = mouseX - tooltipWidth - 12;
            }
            if (posX + (float)tooltipWidth + (float)paddingX > (float)screenWidth) {
                posX = screenWidth - tooltipWidth - paddingX;
            }
            if (posX < (float)paddingX) {
                posX = paddingX;
            }
            if (posY + (float)tooltipHeight + (float)paddingY > (float)screenHeight) {
                posY = screenHeight - tooltipHeight - paddingY;
            }
            if (posY < (float)paddingY) {
                posY = paddingY;
            }
        } else {
            posX -= (float)tooltipWidth;
        }
        return new Vec2(posX, posY);
    }

    public Vec2 adjustPosition() {
        Vec2 otherContextSize;
        Vec2 newPosition = this.context.getTooltipPosition();
        boolean isMainTooltip = this.context.isMainTooltip();
        int paddingX = this.context.getPaddingX();
        int paddingY = this.context.getPaddingY();
        int mouseY = this.context.getMouseY();
        int tooltipHeight = (int)this.context.getTooltipSize().y;
        int screenHeight = this.context.getScreenHeight();
        float posY = mouseY - 12;
        TooltipContext otherContext = this.context.getOtherTooltipContext();
        Vec2 otherContextPosition = otherContext != null ? otherContext.getTooltipPosition() : null;
        Vec2 vec2 = otherContextSize = otherContext != null ? otherContext.getTooltipSize() : null;
        if (isMainTooltip) {
            if (otherContextPosition != null && otherContextSize != null && otherContextPosition.x <= (float)(paddingX * 2)) {
                newPosition = new Vec2(otherContextPosition.x + otherContextSize.x + 24.0f, newPosition.y);
            }
            if (otherContext != null && !otherContext.isMainTooltip()) {
                boolean equippedClampedAtTop;
                int equippedHeight = otherContextSize != null ? (int)otherContextSize.y : 0;
                float equippedPosY = mouseY - 12;
                boolean equippedClampedAtBottom = equippedPosY + (float)equippedHeight + (float)paddingY > (float)screenHeight;
                boolean bl = equippedClampedAtTop = equippedPosY < (float)paddingY;
                if (equippedClampedAtBottom || equippedClampedAtTop) {
                    newPosition = equippedClampedAtBottom ? new Vec2(newPosition.x, (float)(screenHeight - equippedHeight - paddingY)) : new Vec2(newPosition.x, (float)paddingY);
                }
            }
            int margin = 100;
            if (otherContextPosition != null && otherContextSize != null && posY != otherContextPosition.y) {
                int difference = (int)(posY - otherContextPosition.y);
                int n = difference = difference < 0 ? -difference : difference;
                if (difference > margin) {
                    newPosition = new Vec2(newPosition.x, (float)screenHeight / 2.0f - (float)tooltipHeight / 2.0f);
                }
            }
        } else {
            float finalY;
            if (posY + (float)tooltipHeight + (float)paddingY > (float)screenHeight) {
                posY = screenHeight - tooltipHeight - paddingY;
            }
            if (posY < (float)paddingY) {
                posY = paddingY;
            }
            if (otherContextPosition != null && otherContextSize != null) {
                newPosition = new Vec2(0.0f, this.context.getTooltipPosition().y).add(new Vec2(otherContextPosition.x - 24.0f - this.context.getTooltipSize().x, 0.0f));
                newPosition = new Vec2(newPosition.x, otherContextPosition.y);
                if (newPosition.x < (float)this.context.getPaddingX()) {
                    newPosition = new Vec2((float)(this.context.getPaddingX() * 2), newPosition.y);
                }
            }
            int margin = 100;
            if (otherContextPosition != null && otherContextSize != null && posY != otherContextPosition.y) {
                int difference = (int)(posY - otherContextPosition.y);
                int n = difference = difference < 0 ? -difference : difference;
                if (difference > margin) {
                    newPosition = new Vec2(newPosition.x, (float)screenHeight / 2.0f - (float)tooltipHeight / 2.0f);
                }
            }
            if ((finalY = newPosition.y) + (float)tooltipHeight + (float)paddingY > (float)screenHeight) {
                finalY = screenHeight - tooltipHeight - paddingY;
            }
            if (finalY < (float)paddingY) {
                finalY = paddingY;
            }
            newPosition = new Vec2(newPosition.x, finalY);
        }
        return newPosition;
    }
}

