/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.xylonity.tooltipoverhaul.client.frame.CustomFrameData;
import dev.xylonity.tooltipoverhaul.client.frame.CustomFrameManager;
import dev.xylonity.tooltipoverhaul.client.layer.ITooltipLayer;
import dev.xylonity.tooltipoverhaul.client.layer.LayerDepth;
import dev.xylonity.tooltipoverhaul.client.layout.TooltipPositionCalculator;
import dev.xylonity.tooltipoverhaul.client.layout.TooltipSizeCalculator;
import dev.xylonity.tooltipoverhaul.client.util.RenderUtils;
import dev.xylonity.tooltipoverhaul.client.util.TextAxis;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TooltipContext {
    private final GuiGraphics graphics;
    private final Font font;
    private final List<ClientTooltipComponent> components;
    private final int mouseX;
    private final int mouseY;
    private final int screenWidth;
    private final int screenHeight;
    private final ClientTooltipPositioner tooltipPositioner;
    private final ItemStack stack;
    private Vec2 tooltipSize;
    private Vec2 tooltipPosition;
    private LayerDepth layerDepth;
    private List<ITooltipLayer> layers;
    @Nullable
    private final CustomFrameData frameData;
    private final boolean isMainTooltip;
    private final boolean isEmptyTooltip;
    private final boolean hasIcon;
    private final boolean hasDividerLine;
    private final int paddingX;
    private final int paddingY;
    private final TooltipPositionCalculator positionCalculator;
    private final TooltipSizeCalculator sizeCalculator;
    private static final long START_TIME = System.currentTimeMillis();
    @Nullable
    private TooltipContext otherTooltipContext = null;

    public TooltipContext(GuiGraphics graphics, Font font, List<ClientTooltipComponent> components, int mouseX, int mouseY, int screenWidth, int screenHeight, ClientTooltipPositioner tooltipPositioner, @NotNull ItemStack stack, boolean isMainTooltip) {
        this.graphics = graphics;
        this.font = font;
        this.components = components;
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.tooltipPositioner = tooltipPositioner;
        this.stack = stack;
        this.isMainTooltip = isMainTooltip;
        this.frameData = CustomFrameManager.of(stack).orElse(null);
        this.isEmptyTooltip = stack.isEmpty();
        this.hasIcon = RenderUtils.hasIcon(this);
        this.hasDividerLine = RenderUtils.hasDividerLine(this);
        this.paddingX = RenderUtils.calculatePadding(this, TextAxis.X);
        this.paddingY = RenderUtils.calculatePadding(this, TextAxis.Y);
        this.positionCalculator = new TooltipPositionCalculator(this);
        this.sizeCalculator = new TooltipSizeCalculator(this);
    }

    public GuiGraphics getGraphics() {
        return this.graphics;
    }

    public Font getFont() {
        return this.font;
    }

    public List<ClientTooltipComponent> getComponents() {
        return this.components;
    }

    public int getMouseX() {
        return this.mouseX;
    }

    public int getMouseY() {
        return this.mouseY;
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }

    public int getScreenHeight() {
        return this.screenHeight;
    }

    public ClientTooltipPositioner getTooltipPositioner() {
        return this.tooltipPositioner;
    }

    public MultiBufferSource getBuffer() {
        return this.graphics.bufferSource();
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public boolean isMainTooltip() {
        return this.isMainTooltip;
    }

    public void setTooltipSize(Vec2 tooltipSize) {
        this.tooltipSize = tooltipSize;
    }

    public Vec2 getTooltipSize() {
        return this.tooltipSize;
    }

    public void setTooltipPosition(Vec2 tooltipPosition) {
        this.tooltipPosition = tooltipPosition;
    }

    public void setLayerDepth(LayerDepth layerDepth) {
        this.layerDepth = layerDepth;
    }

    public LayerDepth getLayerDepth() {
        return this.layerDepth;
    }

    public Vec2 getTooltipPosition() {
        return this.tooltipPosition;
    }

    public void setTooltipLayers(List<ITooltipLayer> layers) {
        this.layers = layers;
    }

    public List<ITooltipLayer> getTooltipLayers() {
        return this.layers;
    }

    public boolean isEmptyTooltip() {
        return this.isEmptyTooltip;
    }

    public boolean hasIcon() {
        return this.hasIcon;
    }

    public boolean hasDividerLine() {
        return this.hasDividerLine;
    }

    public long getStartTime() {
        return START_TIME;
    }

    public int getPaddingX() {
        return this.paddingX;
    }

    public int getPaddingY() {
        return this.paddingY;
    }

    public TooltipPositionCalculator getPositionCalculator() {
        return this.positionCalculator;
    }

    public TooltipSizeCalculator getSizeCalculator() {
        return this.sizeCalculator;
    }

    @Nullable
    public CustomFrameData getFrameData() {
        return this.frameData;
    }

    public void setOtherTooltipContext(@Nullable TooltipContext otherTooltipContext) {
        this.otherTooltipContext = otherTooltipContext;
    }

    @Nullable
    public TooltipContext getOtherTooltipContext() {
        return this.otherTooltipContext;
    }

    public void flush() {
        this.graphics.flush();
    }

    public PoseStack getPose() {
        return this.graphics.pose();
    }

    public void push(Runnable r) {
        this.getPose().pushPose();
        try {
            r.run();
        }
        finally {
            this.getPose().popPose();
        }
    }

    public void translate(float x, float y, float z) {
        this.getPose().translate(x, y, z);
    }

    public void scale(float x, float y, float z) {
        this.getPose().scale(x, y, z);
    }

    public void multiply(Axis axis, float degrees) {
        this.getPose().mulPose(axis.rotationDegrees(degrees));
    }
}

