/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.badge;

import dev.xylonity.tooltipoverhaul.client.layer.impl.BackgroundLayer;
import dev.xylonity.tooltipoverhaul.client.render.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.util.ColorUtils;
import dev.xylonity.tooltipoverhaul.client.util.RenderUtils;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.phys.Vec2;

public class DefaultEquippedBadge
implements BackgroundLayer {
    private final int color1;
    private final int color2;
    private final int color3;

    public DefaultEquippedBadge(int color1, int color2, int color3) {
        this.color1 = color1;
        this.color2 = color2;
        this.color3 = color3;
    }

    @Override
    public void render(TooltipContext context, Vec2 position) {
        int sizeY = 20;
        int offsetY = 20;
        int x0 = (int)(position.x - 3.0f);
        int y0 = (int)(position.y - (float)sizeY - (float)offsetY);
        int x1 = (int)(position.x + context.getTooltipSize().x + 2.0f);
        int y1 = (int)(position.y - (float)offsetY);
        int backgroundColor = ColorUtils.getBackgroundColor(context);
        context.getGraphics().fill(x0, y0, x1, y1, 0, backgroundColor);
        context.getGraphics().fill(x0, y0 - 1, x1, y0, 0, backgroundColor);
        context.getGraphics().fill(x0, y1 + 1, x1, y1, 0, backgroundColor);
        context.getGraphics().fill(x0 - 1, y0, x0, y1, 0, backgroundColor);
        context.getGraphics().fill(x1 + 1, y0, x1, y1, 0, backgroundColor);
        RenderUtils.renderFrameGradient(context.getGraphics(), x1 - 1, y0 + 1, x0 - x1 + 2, y1 - y0, this.color1, this.color2, this.color3);
        context.getGraphics().fill(x1, y0, x0, y0 + 1, this.color1);
        context.getGraphics().fill(x1, y1, x0, y1 - 1, this.color3);
        MutableComponent text = Component.translatable((String)"tooltipoverhaul.equipped_badge_text");
        int textHeight = ClientTooltipComponent.create((FormattedCharSequence)text.getVisualOrderText()).getHeight();
        int textX = (int)((float)x0 + context.getTooltipSize().x / 2.0f - (float)context.getFont().width((FormattedText)text) / 2.0f + (float)context.getPaddingX());
        int textY = (int)((float)y0 - (float)textHeight / 2.0f + (float)sizeY / 1.7f);
        context.getGraphics().drawString(context.getFont(), (Component)text, textX, textY, this.color1, false);
    }
}

