/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.effect;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.xylonity.tooltipoverhaul.client.layer.impl.EffectLayer;
import dev.xylonity.tooltipoverhaul.client.render.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.util.AnimationUtils;
import dev.xylonity.tooltipoverhaul.client.util.ColorUtils;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Random;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.phys.Vec2;
import org.joml.Matrix4f;

public class CinderEffect
implements EffectLayer {
    private static final int CINDERS_CAP = 18;
    private static final long PER_PARTICLE = 110L;
    private static final float MIN_DISP = -1.0f;
    private static final float MAX_DISP = -4.0f;
    private static final float TOKYO_DRIFT = 8.0f;
    private static final int COLOR_START = -855645528;
    private static final int COLOR_END = -1711300512;
    private static final Deque<Cinder> CINDERS = new ArrayDeque<Cinder>();
    private static long lastSpawn = 0L;

    @Override
    public void render(TooltipContext context, Vec2 position) {
        int positionX = (int)position.x;
        int positionY = (int)position.y;
        int tooltipWidth = (int)context.getTooltipSize().x;
        int tooltipHeight = (int)context.getTooltipSize().y;
        long now = System.currentTimeMillis();
        if (now - lastSpawn >= 110L && CINDERS.size() < 18) {
            CinderEffect.spawn(tooltipWidth, tooltipHeight, now);
            lastSpawn = now;
        }
        context.push(() -> {
            context.getGraphics().enableScissor(positionX - context.getPaddingX() - 1, positionY - context.getPaddingY(), positionX + tooltipWidth + context.getPaddingX(), positionY + tooltipHeight + context.getPaddingY());
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            Matrix4f pose = context.getPose().last().pose();
            CINDERS.removeIf(c -> !c.render(pose, 0.016666668f, now, positionX, positionY, tooltipWidth, tooltipHeight));
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.disableBlend();
            context.getGraphics().disableScissor();
        });
    }

    private static void spawn(int w, int h, long now) {
        Random random = new Random();
        float marginX = 6.0f;
        float localX = marginX + random.nextFloat() * Math.max(2.0f, (float)w - 2.0f * marginX);
        float bottomY = (float)h - 3.0f;
        float localY = bottomY - random.nextFloat() * 4.0f + 5.0f;
        float vy = -1.0f + random.nextFloat() * -3.0f;
        float life = 450.0f + random.nextFloat() * 350.0f;
        float size = 0.8f + random.nextFloat() * 1.2f;
        float ax = (random.nextFloat() * 2.0f - 1.0f) * 8.0f;
        float rot = random.nextFloat() * (float)Math.PI;
        float twinklePhase = random.nextFloat() * ((float)Math.PI * 2);
        if (CINDERS.size() >= 18) {
            CINDERS.pollFirst();
        }
        CINDERS.addLast(new Cinder(localX, localY, vy, ax, size, now, life, rot, twinklePhase));
    }

    private static void drawStar(Matrix4f pose, float cx, float cy, float len, float thickness, float rot, int r, int g, int b, int a) {
        for (int i = 0; i < 4; ++i) {
            float rot2 = rot + (float)i * 1.5707964f;
            float x2 = cx + (float)Math.cos(rot2) * len;
            float y2 = cy + (float)Math.sin(rot2) * len;
            CinderEffect.drawSegment(pose, cx, cy, x2, y2, thickness, Math.max(0.6f, thickness * 0.5f), r, g, b, a);
        }
    }

    private static void drawSegment(Matrix4f pose, float x1, float y1, float x2, float y2, float tStart, float tEnd, int r, int g, int b, int a) {
        float dx = x2 - x1;
        float dy = y2 - y1;
        float len = (float)Math.max(0.001, Math.hypot(dx, dy));
        float nx = -dy / len;
        float ny = dx / len;
        float hsx = nx * tStart * 0.5f;
        float hsy = ny * tStart * 0.5f;
        float hex = nx * tEnd * 0.5f;
        float hey = ny * tEnd * 0.5f;
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder buf = tesselator.begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION_COLOR);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        buf.addVertex(pose, x1 - hsx, y1 - hsy, 0.0f).setColor(r, g, b, a);
        buf.addVertex(pose, x1 + hsx, y1 + hsy, 0.0f).setColor(r, g, b, a);
        buf.addVertex(pose, x2 - hex, y2 - hey, 0.0f).setColor(r, g, b, a);
        buf.addVertex(pose, x2 + hex, y2 + hey, 0.0f).setColor(r, g, b, a);
        try (MeshData data = buf.buildOrThrow();){
            BufferUploader.drawWithShader((MeshData)data);
        }
    }

    private static final class Cinder {
        private float localX;
        private float localY;
        private final float vy;
        private final float ax;
        private final float size;
        private final float baseRot;
        private final long start;
        private final float lifetime;
        private final float twinklePhase;

        Cinder(float localX, float localY, float vy, float ax, float size, long start, float lifetime, float baseRot, float twinklePhase) {
            this.localX = localX;
            this.localY = localY;
            this.vy = vy;
            this.ax = ax;
            this.size = size;
            this.start = start;
            this.lifetime = lifetime;
            this.baseRot = baseRot;
            this.twinklePhase = twinklePhase;
        }

        boolean render(Matrix4f pose, float dt, long now, float tooltipX, float tooltipY, float tooltipW, float tooltipH) {
            float verticalFade;
            float age = now - this.start;
            if (age >= this.lifetime) {
                return false;
            }
            this.localX += this.ax * dt * 0.25f;
            this.localY += this.vy * dt;
            float topLimit = tooltipH * 0.1f;
            if (this.localY < topLimit) {
                return false;
            }
            float bottomFactor = (this.localY - topLimit) / Math.max(1.0f, tooltipH - topLimit);
            bottomFactor = AnimationUtils.clamp01(bottomFactor);
            float k = AnimationUtils.clamp01(age / this.lifetime);
            float lifeFade = (float)Math.pow(1.0f - k, 1.3f);
            float visibility = lifeFade * (verticalFade = 0.4f + 0.6f * bottomFactor);
            if (visibility <= 0.0f) {
                return false;
            }
            float twinkle = 0.85f + 0.15f * (float)Math.sin((float)(now - this.start) * 0.006f + this.twinklePhase);
            float drop = 0.75f + 0.25f * (float)Math.sin((float)now * 0.015f + (float)this.start * 0.003f);
            int alphaCore = (int)(210.0f * visibility * twinkle * drop);
            int alphaGlow = (int)(140.0f * visibility * twinkle * drop);
            if (alphaCore <= 0 && alphaGlow <= 0) {
                return true;
            }
            float colorT = 0.25f + 0.75f * (1.0f - k);
            int coreColor = ColorUtils.lerpColor(-1711300512, -855645528, colorT);
            int glowColor = ColorUtils.lerpColor(-1711300512, -855645528, 0.5f * colorT);
            int cr = coreColor >>> 16 & 0xFF;
            int cg = coreColor >>> 8 & 0xFF;
            int cb = coreColor & 0xFF;
            int gr = glowColor >>> 16 & 0xFF;
            int gg = glowColor >>> 8 & 0xFF;
            int gb = glowColor & 0xFF;
            float rot = this.baseRot + (float)Math.sin((float)this.start * 0.0017f + (float)now * 0.0011f + this.localX * 0.03f) * 0.18f;
            float baseLen = 0.0f + this.size * 2.2f;
            float coreThick = 1.0f + this.size * 0.55f;
            float glowThick = coreThick * 2.0f;
            float lenGlow = baseLen * 1.2f;
            float cx = tooltipX + this.localX;
            float cy = tooltipY + this.localY;
            CinderEffect.drawStar(pose, cx, cy, lenGlow, glowThick, rot, gr, gg, gb, alphaGlow);
            CinderEffect.drawStar(pose, cx, cy, baseLen, coreThick, rot, cr, cg, cb, alphaCore);
            return true;
        }
    }
}

