/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.effect;

import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.xylonity.tooltipoverhaul.client.layer.impl.EffectLayer;
import dev.xylonity.tooltipoverhaul.client.render.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.util.ColorUtils;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.phys.Vec2;
import org.joml.Matrix4f;

public class RimLightEffect
implements EffectLayer {
    private final int color1;
    private final int color2;

    public RimLightEffect(int color1, int color2) {
        this.color1 = color1;
        this.color2 = color2;
    }

    @Override
    public void render(TooltipContext context, Vec2 position) {
        Vec2 tooltipPos = context.getTooltipPosition();
        Vec2 tooltipSize = context.getTooltipSize();
        if (tooltipPos == null || tooltipSize == null) {
            return;
        }
        float time = context.getStartTime();
        float width = 8.0f + 3.0f * (float)Math.cos(time * 1.1f);
        Matrix4f matrix = context.getPose().last().pose();
        VertexConsumer buf = context.getBuffer().getBuffer(RenderType.guiOverlay());
        float basePadding = 4.0f;
        RimLightEffect.draw(matrix, buf, tooltipPos, tooltipSize, width, this.color1, this.color2, basePadding);
        RimLightEffect.draw(matrix, buf, tooltipPos, tooltipSize, width * 1.6f, ColorUtils.mulAlpha(this.color1, 0.35f), this.color2, basePadding + 1.0f);
        for (int edge = 0; edge < 4; ++edge) {
            float k = (float)Math.max(0.0, Math.sin(time * 3.2f + (float)edge * 1.57f));
            if (k < 0.05f) continue;
            RimLightEffect.drawEdge(matrix, buf, tooltipPos, tooltipSize, width * 0.6f, ColorUtils.mulAlpha(this.color1, 0.5f + 0.35f * k), this.color2, edge, basePadding);
        }
    }

    private static void draw(Matrix4f matrix4f, VertexConsumer vertexConsumer, Vec2 tooltipPos, Vec2 tooltipSize, float width, int color1, int color2, float padding) {
        float startX = tooltipPos.x - padding;
        float startY = tooltipPos.y - padding;
        float totalWidth = tooltipSize.x + padding * 2.0f;
        float totalHeight = tooltipSize.y + padding * 2.0f;
        float x0 = startX;
        float y0 = startY;
        float x1 = startX + width;
        float y1 = startY + width;
        float x2 = startX + totalWidth - width;
        float y2 = startY + totalHeight - width;
        float x3 = startX + totalWidth;
        float y3 = startY + totalHeight;
        vertexConsumer.addVertex(matrix4f, x0, y0, 0.0f).setColor(color1);
        vertexConsumer.addVertex(matrix4f, x0, y3, 0.0f).setColor(color1);
        vertexConsumer.addVertex(matrix4f, x1, y2, 0.0f).setColor(color2);
        vertexConsumer.addVertex(matrix4f, x1, y1, 0.0f).setColor(color2);
        vertexConsumer.addVertex(matrix4f, x0, y0, 0.0f).setColor(color1);
        vertexConsumer.addVertex(matrix4f, x1, y1, 0.0f).setColor(color2);
        vertexConsumer.addVertex(matrix4f, x2, y1, 0.0f).setColor(color2);
        vertexConsumer.addVertex(matrix4f, x3, y0, 0.0f).setColor(color1);
        vertexConsumer.addVertex(matrix4f, x2, y1, 0.0f).setColor(color2);
        vertexConsumer.addVertex(matrix4f, x2, y2, 0.0f).setColor(color2);
        vertexConsumer.addVertex(matrix4f, x3, y3, 0.0f).setColor(color1);
        vertexConsumer.addVertex(matrix4f, x3, y0, 0.0f).setColor(color1);
        vertexConsumer.addVertex(matrix4f, x1, y2, 0.0f).setColor(color2);
        vertexConsumer.addVertex(matrix4f, x0, y3, 0.0f).setColor(color1);
        vertexConsumer.addVertex(matrix4f, x3, y3, 0.0f).setColor(color1);
        vertexConsumer.addVertex(matrix4f, x2, y2, 0.0f).setColor(color2);
    }

    private static void drawEdge(Matrix4f matrix4f, VertexConsumer vertexConsumer, Vec2 tooltipPos, Vec2 tooltipSize, float width, int color1, int color2, int edge, float padding) {
        float startX = tooltipPos.x - padding;
        float startY = tooltipPos.y - padding;
        float totalWidth = tooltipSize.x + padding * 2.0f;
        float totalHeight = tooltipSize.y + padding * 2.0f;
        float x0 = startX;
        float y0 = startY;
        float x1 = startX + width;
        float y1 = startY + width;
        float x2 = startX + totalWidth - width;
        float y2 = startY + totalHeight - width;
        float x3 = startX + totalWidth;
        float y3 = startY + totalHeight;
        switch (edge) {
            case 0: {
                vertexConsumer.addVertex(matrix4f, x0, y0, 0.0f).setColor(color1);
                vertexConsumer.addVertex(matrix4f, x0, y3, 0.0f).setColor(color1);
                vertexConsumer.addVertex(matrix4f, x1, y2, 0.0f).setColor(color2);
                vertexConsumer.addVertex(matrix4f, x1, y1, 0.0f).setColor(color2);
                break;
            }
            case 1: {
                vertexConsumer.addVertex(matrix4f, x0, y0, 0.0f).setColor(color1);
                vertexConsumer.addVertex(matrix4f, x1, y1, 0.0f).setColor(color2);
                vertexConsumer.addVertex(matrix4f, x2, y1, 0.0f).setColor(color2);
                vertexConsumer.addVertex(matrix4f, x3, y0, 0.0f).setColor(color1);
                break;
            }
            case 2: {
                vertexConsumer.addVertex(matrix4f, x2, y1, 0.0f).setColor(color2);
                vertexConsumer.addVertex(matrix4f, x2, y2, 0.0f).setColor(color2);
                vertexConsumer.addVertex(matrix4f, x3, y3, 0.0f).setColor(color1);
                vertexConsumer.addVertex(matrix4f, x3, y0, 0.0f).setColor(color1);
                break;
            }
            case 3: {
                vertexConsumer.addVertex(matrix4f, x1, y2, 0.0f).setColor(color2);
                vertexConsumer.addVertex(matrix4f, x0, y3, 0.0f).setColor(color1);
                vertexConsumer.addVertex(matrix4f, x3, y3, 0.0f).setColor(color1);
                vertexConsumer.addVertex(matrix4f, x2, y2, 0.0f).setColor(color2);
            }
        }
    }
}

