/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.effect;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.xylonity.tooltipoverhaul.client.layer.impl.EffectLayer;
import dev.xylonity.tooltipoverhaul.client.render.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.util.AnimationUtils;
import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.phys.Vec2;
import org.joml.Matrix4f;

public class SonarEffect
implements EffectLayer {
    private static final int RINGS = 1;
    private static final long PER_PULSE = 1200L;
    private static final int LIFETIME = 1400;
    private static final float THICKNESS = 10.0f;
    private static final float GLOW = 2.6f;
    private static final int COLOR = -2002724609;
    private static long lastSpawn = 0L;
    private static final Deque<Pulse> pulses = new ArrayDeque<Pulse>();

    @Override
    public void render(TooltipContext context, Vec2 position) {
        int positionX = (int)position.x;
        int positionY = (int)position.y;
        int tooltipWidth = (int)context.getTooltipSize().x;
        int tooltipHeight = (int)context.getTooltipSize().y;
        long now = System.currentTimeMillis();
        float centerX = (float)positionX + (float)tooltipWidth * 0.5f;
        float centerY = (float)positionY + (float)tooltipHeight * 0.5f;
        if (now - lastSpawn >= 1200L && pulses.size() < 1) {
            pulses.addLast(new Pulse(now, 1400, (float)Math.hypot(tooltipWidth, tooltipHeight) * 0.6f, 0.0f, -2002724609));
            lastSpawn = now;
        }
        context.push(() -> {
            context.getGraphics().enableScissor(positionX - context.getPaddingX() - 1, positionY - context.getPaddingY(), positionX + tooltipWidth + context.getPaddingX(), positionY + tooltipHeight + context.getPaddingY());
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            pulses.removeIf(p -> !p.render(context.getPose().last().pose(), now, centerX, centerY));
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.disableBlend();
            context.getGraphics().disableScissor();
        });
    }

    private static void draw(Matrix4f pose, float cx, float cy, float innerR, float outerR, int r, int g, int b, int alphaPeak) {
        if (outerR <= 1.0f) {
            return;
        }
        if (innerR < 0.0f) {
            innerR = 0.0f;
        }
        if (outerR - innerR <= 0.5f) {
            outerR = innerR + 0.5f;
        }
        int segments = Math.max(16, (int)(outerR * 0.8f));
        float midR = innerR + (outerR - innerR) * 0.5f;
        Tesselator tesselator = Tesselator.getInstance();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder buf = tesselator.begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION_COLOR);
        for (int i = 0; i <= segments; ++i) {
            double rot = (double)i * (Math.PI * 2 / (double)segments);
            float function = (float)Math.cos(rot);
            float sin = (float)Math.sin(rot);
            buf.addVertex(pose, cx + function * midR, cy + sin * midR, 0.0f).setColor(r, g, b, alphaPeak);
            buf.addVertex(pose, cx + function * innerR, cy + sin * innerR, 0.0f).setColor(r, g, b, 0);
        }
        try (MeshData data = buf.buildOrThrow();){
            BufferUploader.drawWithShader((MeshData)data);
        }
        BufferBuilder buf2 = tesselator.begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION_COLOR);
        for (int i = 0; i <= segments; ++i) {
            double rot = (double)i * (Math.PI * 2 / (double)segments);
            float function = (float)Math.cos(rot);
            float sin = (float)Math.sin(rot);
            buf2.addVertex(pose, cx + function * outerR, cy + sin * outerR, 0.0f).setColor(r, g, b, 0);
            buf2.addVertex(pose, cx + function * midR, cy + sin * midR, 0.0f).setColor(r, g, b, alphaPeak);
        }
        try (MeshData data = buf2.buildOrThrow();){
            BufferUploader.drawWithShader((MeshData)data);
        }
    }

    private record Pulse(long start, int lifetime, float radiusS, float radiusE, int color) {
        boolean render(Matrix4f pose, long now, float centerX, float centerY) {
            float time = (float)(now - this.start) / (float)this.lifetime;
            if (time >= 1.0f) {
                return false;
            }
            float radius = AnimationUtils.lerp(this.radiusS, this.radiusE, AnimationUtils.easeInOutCubic(time));
            float innerCore = Math.max(0.0f, radius - 5.0f);
            float innerGlow = Math.max(0.0f, radius - 13.0f);
            float outerGlow = Math.max(innerGlow + 0.5f, radius + 13.0f);
            if (outerGlow <= 1.0f) {
                return true;
            }
            int red = this.color >>> 16 & 0xFF;
            int green = this.color >>> 8 & 0xFF;
            int blue = this.color & 0xFF;
            float alpha = (float)Math.sin(Math.PI * (double)AnimationUtils.clamp01(time));
            SonarEffect.draw(pose, centerX, centerY, innerGlow, outerGlow, red, green, blue, (int)((float)((int)(alpha * 90.0f)) * 0.65f));
            SonarEffect.draw(pose, centerX, centerY, innerCore, Math.max(innerCore + 0.5f, radius + 5.0f), red, green, blue, (int)(alpha * 170.0f));
            return true;
        }
    }
}

